/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import poussecafe.eclipse.plugin.builder.JdtClassResolver;
import poussecafe.eclipse.plugin.builder.ResourceSource;
import poussecafe.source.Source;
import poussecafe.source.analysis.ClassResolver;
import poussecafe.source.validation.SourceFileLine;
import poussecafe.source.validation.ValidationMessage;
import poussecafe.source.validation.ValidationMessageType;
import poussecafe.source.validation.ValidationResult;
import poussecafe.source.validation.Validator;

public class PousseCafeBuilder
extends IncrementalProjectBuilder {
    private static final String MARKER_TYPE = "poussecafe.eclipse.plugin.pousseCafeProblem";
    @Inject
    private ILog logger;
    private Validator validator;
    private Map<String, IFile> files = new HashMap<String, IFile>();
    public static final String BUILDER_ID = "poussecafe.eclipse.plugin.pousseCafeBuilder";

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.deleteProjectPousseCafeMarkers();
    }

    private void deleteProjectPousseCafeMarkers() {
        try {
            this.getProject().deleteMarkers(MARKER_TYPE, true, 2);
        }
        catch (CoreException e) {
            this.logger.error("Unable to delete markers", (Throwable)e);
        }
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        this.validateProject(monitor);
        return null;
    }

    protected void validateProject(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        this.validator = new Validator((ClassResolver)new JdtClassResolver(JavaCore.create((IProject)project)));
        this.files.clear();
        try {
            project.accept((IResourceVisitor)new ResourceVisitor());
        }
        catch (CoreException e) {
            this.logger.error("Unable to validate project", (Throwable)e);
        }
        this.refreshMarkers();
    }

    private void refreshMarkers() {
        this.validator.validate();
        this.deleteProjectPousseCafeMarkers();
        ValidationResult result = this.validator.result();
        for (ValidationMessage message : result.messages()) {
            SourceFileLine location = message.location();
            IFile file = this.files.get(location.sourceFile().id());
            if (file != null) {
                this.addMarker(file, message.message(), location.line(), this.severity(message.type()));
                continue;
            }
            this.logger.error("Unknown file " + location.sourceFile().id());
        }
    }

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException e) {
            this.logger.error("Unable to add marker", (Throwable)e);
        }
    }

    private int severity(ValidationMessageType type) {
        if (type == ValidationMessageType.ERROR) {
            return 2;
        }
        if (type == ValidationMessageType.WARNING) {
            return 1;
        }
        return 0;
    }

    class ResourceVisitor
    implements IResourceVisitor {
        ResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            if (this.isJavaSourceFile(resource)) {
                IFile file = (IFile)resource;
                ResourceSource source = new ResourceSource.Builder().project(PousseCafeBuilder.this.getProject()).file(file).build();
                PousseCafeBuilder.this.files.put(source.id(), file);
                PousseCafeBuilder.this.validator.includeSource((Source)source);
            }
            return true;
        }

        private boolean isJavaSourceFile(IResource resource) {
            return resource instanceof IFile && resource.getName().endsWith(".java");
        }
    }
}

