/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import poussecafe.source.Source;

public class ResourceSource
implements Source {
    private ICompilationUnit compilationUnit;
    private String id;

    public void configure(ASTParser parser) {
        parser.setSource(this.compilationUnit);
    }

    public String id() {
        return this.id;
    }

    private ResourceSource() {
    }

    public static class Builder {
        private IFile file;
        private ResourceSource source = new ResourceSource();
        private IProject project;

        public ResourceSource build() {
            Objects.requireNonNull(this.file);
            this.source.id = this.file.getFullPath().toString();
            Objects.requireNonNull(this.project);
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            this.source.compilationUnit = (ICompilationUnit)JavaCore.create((IResource)this.file, (IJavaProject)javaProject);
            return this.source;
        }

        public Builder file(IFile file) {
            this.file = file;
            return this;
        }

        public Builder project(IProject project) {
            this.project = project;
            return this;
        }
    }
}

