/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import poussecafe.eclipse.plugin.builder.JdtResolvedClass;
import poussecafe.source.analysis.ClassResolver;

public class JdtClassResolver
extends ClassResolver {
    private IJavaProject project;
    private Map<IType, ITypeHierarchy> supertypeHierarchyCache = new HashMap<IType, ITypeHierarchy>();
    private Map<IType, ITypeHierarchy> typeHierarchyCache = new HashMap<IType, ITypeHierarchy>();

    protected JdtResolvedClass loadClass(String name) throws ClassNotFoundException {
        try {
            IType type = this.project.findType(name);
            if (type == null) {
                throw new ClassNotFoundException();
            }
            return this.resolve(type);
        }
        catch (JavaModelException e) {
            throw new ClassNotFoundException("Unable to find type " + name, e);
        }
    }

    public JdtResolvedClass resolve(IType type) {
        return new JdtResolvedClass.Builder().resolver(this).type(type).build();
    }

    public Optional<JdtResolvedClass> declaringClass(IType type) {
        try {
            String fullyQualifiedName = type.getFullyQualifiedName();
            int declaringClassNameEnd = this.declaringClassNameEnd(fullyQualifiedName);
            if (declaringClassNameEnd == -1) {
                return Optional.empty();
            }
            return Optional.of(this.loadClass(fullyQualifiedName.substring(0, declaringClassNameEnd)));
        }
        catch (ClassNotFoundException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error("Unable to get declaring class of " + type, (Throwable)e);
            return Optional.empty();
        }
    }

    private int declaringClassNameEnd(String fullyQualifiedName) {
        int i = fullyQualifiedName.length() - 1;
        while (i >= 0) {
            if (fullyQualifiedName.charAt(i) == '$') {
                return i;
            }
            --i;
        }
        return -1;
    }

    public JdtClassResolver(IJavaProject project) {
        Objects.requireNonNull(project);
        this.project = project;
    }

    public ITypeHierarchy newSupertypeHierarchy(IType type) {
        return this.supertypeHierarchyCache.computeIfAbsent(type, this::supertypeHierarchy);
    }

    private ITypeHierarchy supertypeHierarchy(IType type) {
        try {
            return type.newSupertypeHierarchy(null);
        }
        catch (JavaModelException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public ITypeHierarchy newTypeHierarchy(IType type) {
        return this.typeHierarchyCache.computeIfAbsent(type, this::typeHierarchy);
    }

    private ITypeHierarchy typeHierarchy(IType type) {
        try {
            return type.newTypeHierarchy(null);
        }
        catch (JavaModelException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

