/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import poussecafe.eclipse.plugin.builder.JdtClassResolver;
import poussecafe.source.analysis.ClassResolver;
import poussecafe.source.analysis.Name;
import poussecafe.source.analysis.ResolvedClass;

public class JdtResolvedClass
implements ResolvedClass {
    private IType type;
    private JdtClassResolver resolver;

    public Optional<ResolvedClass> declaringClass() {
        if (this.type.getFullyQualifiedName().charAt(36) != '\uffffffff') {
            return this.resolver.declaringClass(this.type).map(jdtClass -> jdtClass);
        }
        return Optional.empty();
    }

    public IType type() {
        return this.type;
    }

    public List<ResolvedClass> innerClasses() {
        try {
            return Arrays.stream(this.type.getTypes()).filter(this::isClass).map(this::newResolvedClass).collect(Collectors.toList());
        }
        catch (JavaModelException e) {
            this.logError("Unable to extract inner classes", (Exception)((Object)e));
            return Collections.emptyList();
        }
    }

    private void logError(String message, Exception e) {
        Platform.getLog(this.getClass()).error(message, (Throwable)e);
    }

    private boolean isClass(IType candidate) {
        try {
            return candidate.isClass() || candidate.isInterface();
        }
        catch (JavaModelException e) {
            this.logError("Unable to extract inner classes", (Exception)((Object)e));
            return false;
        }
    }

    private JdtResolvedClass newResolvedClass(IType type) {
        return new Builder().resolver(this.resolver).type(type).build();
    }

    public boolean instanceOf(String name) throws ClassNotFoundException {
        JdtResolvedClass consideredType = this.resolver.loadClass(name);
        return this.instanceOf(consideredType);
    }

    private boolean instanceOf(JdtResolvedClass consideredType) {
        if (consideredType.name().equals((Object)this.name())) {
            return true;
        }
        ITypeHierarchy hierarchy = this.resolver.newSupertypeHierarchy(this.type);
        return hierarchy.contains(consideredType.type);
    }

    public Name name() {
        return new Name(this.type.getFullyQualifiedName('.'));
    }

    public ClassResolver resolver() {
        return this.resolver;
    }

    public Optional<Object> staticFieldValue(String constantName) {
        return Optional.ofNullable(this.getConstant(this.type.getField(constantName)));
    }

    private Object getConstant(IField field) {
        try {
            return field.getConstant();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private JdtResolvedClass() {
    }

    public static class Builder {
        private JdtResolvedClass resolvedClass = new JdtResolvedClass();

        public JdtResolvedClass build() {
            return this.resolvedClass;
        }

        public Builder resolver(JdtClassResolver resolver) {
            this.resolvedClass.resolver = resolver;
            return this;
        }

        public Builder type(IType type) {
            this.resolvedClass.type = type;
            return this;
        }
    }
}

