/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import poussecafe.eclipse.plugin.builder.JdtClassPathExplorer;
import poussecafe.eclipse.plugin.builder.JdtClassResolver;
import poussecafe.eclipse.plugin.builder.ResourceSource;
import poussecafe.source.Source;
import poussecafe.source.analysis.ClassResolver;
import poussecafe.source.validation.SourceFileLine;
import poussecafe.source.validation.ValidationMessage;
import poussecafe.source.validation.ValidationMessageType;
import poussecafe.source.validation.ValidationResult;
import poussecafe.source.validation.Validator;

public class PousseCafeBuilder
extends IncrementalProjectBuilder {
    private static final String MARKER_TYPE = "poussecafe.eclipse.plugin.pousseCafeProblem";
    private ILog logger = Platform.getLog(((Object)((Object)this)).getClass());
    private Validator validator;
    private IJavaProject javaProject;
    private Map<String, IFile> files = new HashMap<String, IFile>();
    public static final String BUILDER_ID = "poussecafe.eclipse.plugin.pousseCafeBuilder";

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.deleteProjectPousseCafeMarkers();
    }

    private void deleteProjectPousseCafeMarkers() {
        try {
            this.getProject().deleteMarkers(MARKER_TYPE, true, 2);
        }
        catch (CoreException e) {
            this.logger.error("Unable to delete markers", (Throwable)e);
        }
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Validating " + this.getProject().getName(), 3);
        this.validateProject(monitor);
        return new IProject[0];
    }

    protected void validateProject(IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Walking project...");
        JdtClassResolver classResolver = new JdtClassResolver(this.javaProject());
        this.validator = new Validator((ClassResolver)classResolver, Optional.of(new JdtClassPathExplorer(classResolver)));
        this.files.clear();
        try {
            this.getProject().accept((IResourceVisitor)new ResourceVisitor(monitor));
        }
        catch (CoreException e) {
            this.logger.error("Unable to validate project", (Throwable)e);
        }
        monitor.worked(1);
        monitor.subTask("Validating...");
        this.validator.validate();
        monitor.worked(2);
        monitor.subTask("Refreshing markers...");
        this.refreshMarkers();
        monitor.worked(3);
    }

    private IJavaProject javaProject() {
        if (this.javaProject == null) {
            this.javaProject = JavaCore.create((IProject)this.getProject());
        }
        return this.javaProject;
    }

    private void refreshMarkers() {
        this.deleteProjectPousseCafeMarkers();
        ValidationResult result = this.validator.result();
        for (ValidationMessage message : result.messages()) {
            SourceFileLine location = message.location();
            IFile file = this.files.get(location.sourceFile().id());
            if (file != null) {
                this.addMarker(file, message.message(), location.line(), this.severity(message.type()));
                continue;
            }
            this.logger.error("Unknown file " + location.sourceFile().id());
        }
    }

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException e) {
            this.logger.error("Unable to add marker", (Throwable)e);
        }
    }

    private int severity(ValidationMessageType type) {
        if (type == ValidationMessageType.ERROR) {
            return 2;
        }
        if (type == ValidationMessageType.WARNING) {
            return 1;
        }
        return 0;
    }

    class ResourceVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;

        ResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) {
            if (this.isJavaSourceFile(resource)) {
                IFile file = (IFile)resource;
                ResourceSource source = new ResourceSource.Builder().project(PousseCafeBuilder.this.javaProject()).file(file).build();
                this.monitor.subTask("Validation: scanning " + source.id());
                PousseCafeBuilder.this.files.put(source.id(), file);
                try {
                    PousseCafeBuilder.this.validator.includeSource((Source)source);
                }
                catch (Exception e) {
                    PousseCafeBuilder.this.logger.error("Skipping resource " + source.id(), (Throwable)e);
                }
            }
            return true;
        }

        private boolean isJavaSourceFile(IResource resource) {
            String extension = resource.getFileExtension();
            return resource instanceof IFile && extension != null && extension.equals("java");
        }
    }
}

