/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.IType;
import poussecafe.eclipse.plugin.builder.JdtClassResolver;
import poussecafe.eclipse.plugin.builder.JdtResolvedClass;
import poussecafe.eclipse.plugin.builder.TypeHierarchy;
import poussecafe.source.analysis.Name;
import poussecafe.source.analysis.ResolvedClass;
import poussecafe.source.validation.ClassPathExplorer;

public class JdtClassPathExplorer
implements ClassPathExplorer {
    private JdtClassResolver classResolver;

    public Set<ResolvedClass> getSubTypesOf(Name superTypeName) {
        JdtResolvedClass resolvedClass = (JdtResolvedClass)this.classResolver.loadClass(superTypeName).orElseThrow();
        TypeHierarchy hierarchy = this.classResolver.typeHierarchies().newTypeHierarchy(resolvedClass.type());
        return Arrays.stream(hierarchy.getAllTypes()).filter(type -> type != resolvedClass.type()).map(type -> this.classResolver.resolve((IType)type)).collect(Collectors.toSet());
    }

    public JdtClassPathExplorer(JdtClassResolver classResolver) {
        Objects.requireNonNull(classResolver);
        this.classResolver = classResolver;
    }
}

