/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;

public class TypeHierarchy {
    private ITypeHierarchy typeHierarchy;
    private Set<String> qualifiedNamesIndex;

    public TypeHierarchy(ITypeHierarchy typeHierarchy) {
        Objects.requireNonNull(typeHierarchy);
        this.typeHierarchy = typeHierarchy;
        this.buildQualfiedNamesIndex();
    }

    public boolean contains(IType type) {
        return this.qualifiedNamesIndex().contains(type.getFullyQualifiedName());
    }

    private Set<String> qualifiedNamesIndex() {
        if (this.qualifiedNamesIndex == null) {
            this.buildQualfiedNamesIndex();
        }
        return this.qualifiedNamesIndex;
    }

    private void buildQualfiedNamesIndex() {
        this.qualifiedNamesIndex = new HashSet<String>();
        IType[] iTypeArray = this.typeHierarchy.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            this.qualifiedNamesIndex.add(type.getFullyQualifiedName());
            ++n2;
        }
    }

    public IType[] getAllTypes() {
        return this.typeHierarchy.getAllTypes();
    }
}

