/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import poussecafe.eclipse.plugin.builder.JdtResolvedClass;
import poussecafe.eclipse.plugin.builder.TypeHierarchies;
import poussecafe.source.analysis.ClassResolver;
import poussecafe.source.analysis.Name;

public class JdtClassResolver
extends ClassResolver {
    private Map<Name, List<IType>> searchResults = new HashMap<Name, List<IType>>();
    private IJavaProject project;
    private TypeHierarchies typeHierarchies = new TypeHierarchies();
    private SearchEngine searchEngine;

    protected JdtResolvedClass loadClass(String name) throws ClassNotFoundException {
        List<IType> types = this.loadType(name);
        if (types.isEmpty()) {
            throw new ClassNotFoundException(name);
        }
        return this.resolve(types);
    }

    List<IType> loadType(String name) throws ClassNotFoundException {
        try {
            IType type = this.project.findType(name);
            if (type == null) {
                return this.searchType(new Name(name));
            }
            return Arrays.asList(type);
        }
        catch (JavaModelException e) {
            throw new ClassNotFoundException("Error while searching for type " + name, e);
        }
    }

    private List<IType> searchType(Name typeName) {
        return this.searchResults.computeIfAbsent(typeName, this::doSearchType);
    }

    private List<IType> doSearchType(Name typeName) {
        SearchRequestor requestor = new SearchRequestor();
        try {
            this.searchEngine.searchAllTypeNames(typeName.qualifier().toCharArray(), 0, typeName.simple().toCharArray(), 0, 10, SearchEngine.createWorkspaceScope(), (TypeNameMatchRequestor)requestor, 1, null);
        }
        catch (JavaModelException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error("Unable to search for types", (Throwable)e);
        }
        return requestor.foundTypes;
    }

    public JdtResolvedClass resolve(Collection<IType> types) {
        return new JdtResolvedClass.Builder().resolver(this).types(types).build();
    }

    public JdtClassResolver(IJavaProject project) {
        Objects.requireNonNull(project);
        this.project = project;
        this.searchEngine = new SearchEngine();
    }

    public TypeHierarchies typeHierarchies() {
        return this.typeHierarchies;
    }

    private static class SearchRequestor
    extends TypeNameMatchRequestor {
        private List<IType> foundTypes = new ArrayList<IType>();

        private SearchRequestor() {
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            this.foundTypes.add(match.getType());
        }
    }
}

