/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import poussecafe.eclipse.plugin.editors.EmilConfiguration;
import poussecafe.eclipse.plugin.editors.Style;

public class EmilEditor
extends TextEditor {
    private Style style;
    private static final String EMIL_PROBLEM_MARKER = "poussecafe.eclipse.plugin.emilProblem";
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public EmilEditor() {
        this.setSourceViewerConfiguration(new EmilConfiguration(this));
        this.setDocumentProvider((IDocumentProvider)new FileDocumentProvider());
    }

    public Style style() {
        if (this.style == null) {
            this.style = new Style();
        }
        return this.style;
    }

    public void dispose() {
        this.clearMarkers();
        if (this.style != null) {
            this.style.dispose();
            this.style = null;
        }
        super.dispose();
    }

    public void clearMarkers() {
        try {
            IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
            file.deleteMarkers(EMIL_PROBLEM_MARKER, true, 2);
        }
        catch (CoreException e) {
            this.logger.error("Unable to clear markers", (Throwable)e);
        }
    }

    public void addMarker(String message, int lineNumber, int severity, Position position) {
        try {
            IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
            IMarker marker = file.createMarker(EMIL_PROBLEM_MARKER);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            marker.setAttribute("lineNumber", lineNumber);
            if (position != null) {
                marker.setAttribute("charStart", position.getOffset());
                marker.setAttribute("charEnd", position.getOffset() + position.getLength());
            }
        }
        catch (CoreException e) {
            this.logger.error("Unable to add marker", (Throwable)e);
        }
    }
}

