/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.views;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import poussecafe.eclipse.plugin.builder.JdtClassResolver;
import poussecafe.eclipse.plugin.views.ModelBuildingResourceVisitor;
import poussecafe.source.SourceModelBuilder;
import poussecafe.source.analysis.ClassResolver;
import poussecafe.source.emil.EmilExporter;
import poussecafe.source.model.Model;
import poussecafe.source.model.ProcessModel;

public class ProcessListView
extends ViewPart {
    public static final String ID = "poussecafe.eclipse.plugin.views.ProcessListView";
    @Inject
    IWorkbench workbench;
    private TableViewer viewer;
    private ISelectionListener selectionListener = (part, selection) -> {
        TreeSelection packageSelection;
        if (part instanceof IPackagesViewPart && selection instanceof TreeSelection && !selection.isEmpty() && (packageSelection = (TreeSelection)selection).getFirstElement() instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)packageSelection.getFirstElement();
            this.refreshProcessList(javaProject, false);
        }
    };
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IJavaProject currentProject;
    private Model sourceModel;
    private static final String PLUGIN_TEMP_FOLDER = ".pousse-cafe";

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput((Object)new String[0]);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
        this.registerDoubleClickAction();
        this.fillActionBar();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
        super.dispose();
    }

    private void refreshProcessList(IJavaProject javaProject, boolean forceRefresh) {
        this.logger.debug("Trying to refresh process list...");
        IProject project = javaProject.getProject();
        if (this.isPousseCafeProject(project)) {
            if (!forceRefresh && javaProject.equals(this.currentProject)) {
                return;
            }
            this.currentProject = javaProject;
            Job job = Job.create((String)("Compute process list of project " + project.getName()), monitor -> {
                JdtClassResolver classResolver = new JdtClassResolver(this.currentProject);
                SourceModelBuilder modelBuilder = new SourceModelBuilder((ClassResolver)classResolver);
                try {
                    project.accept((IResourceVisitor)new ModelBuildingResourceVisitor(this.currentProject, modelBuilder));
                    this.sourceModel = modelBuilder.build();
                    final String[] processNames = (String[])this.sourceModel.processes().stream().map(ProcessModel::simpleName).sorted().toArray(String[]::new);
                    UIJob uiJob = new UIJob("Refresh process list"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            ProcessListView.this.viewer.setInput((Object)processNames);
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.schedule();
                }
                catch (CoreException e) {
                    Platform.getLog(((Object)((Object)this)).getClass()).error("Unable to visit project " + project.getName(), (Throwable)e);
                }
            });
            job.schedule();
        }
    }

    private boolean isPousseCafeProject(IProject project) {
        try {
            return project.hasNature("poussecafe.eclipse.plugin.pousseCafeNature");
        }
        catch (CoreException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error("Unable to detect project nature " + project.getName(), (Throwable)e);
            return false;
        }
    }

    private void registerDoubleClickAction() {
        Action doubleClickAction = new Action(){

            public void run() {
                IStructuredSelection selection = ProcessListView.this.viewer.getStructuredSelection();
                String processName = (String)selection.getFirstElement();
                EmilExporter exporter = new EmilExporter.Builder().model(ProcessListView.this.sourceModel).processName(Optional.of(processName)).build();
                String emil = exporter.toEmil();
                try {
                    String emilFileName = ProcessListView.this.emilFileName(processName);
                    IFile emilFile = ProcessListView.this.createTempFile(emilFileName);
                    emilFile.refreshLocal(0, null);
                    ByteArrayInputStream buffer = new ByteArrayInputStream(emil.getBytes());
                    if (emilFile.exists()) {
                        emilFile.setContents((InputStream)buffer, 1, null);
                    } else {
                        emilFile.create((InputStream)buffer, false, null);
                    }
                    IWorkbenchWindow workbenchWindow = ProcessListView.this.getSite().getWorkbenchWindow();
                    IEditorRegistry editorRegistry = workbenchWindow.getWorkbench().getEditorRegistry();
                    IEditorDescriptor editorDescriptor = editorRegistry.getDefaultEditor(emilFileName);
                    workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(emilFile), editorDescriptor.getId());
                }
                catch (CoreException e) {
                    Platform.getLog(((Object)((Object)this)).getClass()).error("Unable to write EMIL file", (Throwable)e);
                }
            }
        };
        this.viewer.addDoubleClickListener(arg_0 -> ProcessListView.lambda$4(doubleClickAction, arg_0));
    }

    private String emilFileName(String processName) {
        return String.valueOf(processName) + ".emil";
    }

    private IFile createTempFile(String fileName) throws CoreException {
        IProject project = this.currentProject.getProject();
        IFolder tempFolder = project.getFolder(PLUGIN_TEMP_FOLDER);
        tempFolder.refreshLocal(2, null);
        if (!tempFolder.exists()) {
            tempFolder.create(false, true, null);
        }
        return tempFolder.getFile(fileName);
    }

    private void fillActionBar() {
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        IAction refreshListAction = this.buildRefreshListAction();
        toolBar.add(refreshListAction);
    }

    private IAction buildRefreshListAction() {
        Action action = new Action(){

            public void run() {
                if (ProcessListView.this.currentProject != null) {
                    ProcessListView.this.refreshProcessList(ProcessListView.this.currentProject, true);
                }
            }
        };
        action.setText("Reload");
        action.setToolTipText("Reload process list");
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
        return action;
    }

    private static /* synthetic */ void lambda$4(2 var0, DoubleClickEvent event) {
        var0.run();
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return ProcessListView.this.workbench.getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

