/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import poussecafe.eclipse.plugin.builder.JdtResolvedClass;
import poussecafe.eclipse.plugin.builder.TypeHierarchies;
import poussecafe.eclipse.plugin.core.JavaSearchEngine;
import poussecafe.source.analysis.ClassResolver;
import poussecafe.source.analysis.Name;

public class JdtClassResolver
extends ClassResolver {
    private Map<Name, List<IType>> searchResults = new HashMap<Name, List<IType>>();
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IJavaProject project;
    private TypeHierarchies typeHierarchies = new TypeHierarchies();
    private JavaSearchEngine searchEngine;
    private Map<String, Boolean> instanceOfRelations = new HashMap<String, Boolean>();

    protected JdtResolvedClass loadClass(String name) throws ClassNotFoundException {
        List<IType> types = this.loadType(name);
        if (types.isEmpty()) {
            throw new ClassNotFoundException(name);
        }
        return this.resolve(types);
    }

    List<IType> loadType(String name) throws ClassNotFoundException {
        try {
            IType type = this.project.findType(name);
            if (type == null) {
                return this.searchType(new Name(name));
            }
            return Arrays.asList(type);
        }
        catch (JavaModelException e) {
            throw new ClassNotFoundException("Error while searching for type " + name, e);
        }
    }

    private List<IType> searchType(Name typeName) {
        return this.searchResults.computeIfAbsent(typeName, this::doSearchType);
    }

    private List<IType> doSearchType(Name typeName) {
        this.logger.debug("Searching for type {}", (Object)typeName);
        return this.searchEngine.searchType(typeName);
    }

    public JdtResolvedClass resolve(Collection<IType> types) {
        return new JdtResolvedClass.Builder().resolver(this).types(types).build();
    }

    public JdtClassResolver(IJavaProject project) {
        Objects.requireNonNull(project);
        this.project = project;
        this.searchEngine = new JavaSearchEngine();
    }

    public TypeHierarchies typeHierarchies() {
        return this.typeHierarchies;
    }

    public boolean instanceOf(JdtResolvedClass subject, JdtResolvedClass supertype) {
        String relation = this.relation(subject, supertype);
        Boolean value = this.instanceOfRelations.get(relation);
        if (value != null) {
            return value;
        }
        value = this.computeInstanceOf(subject, supertype);
        this.instanceOfRelations.put(relation, value);
        return value;
    }

    private String relation(JdtResolvedClass subject, JdtResolvedClass supertype) {
        return String.valueOf(subject.name().toString()) + "+" + supertype.name().toString();
    }

    private Boolean computeInstanceOf(JdtResolvedClass subject, JdtResolvedClass supertype) {
        if (subject.isInterface() && !supertype.isInterface()) {
            return false;
        }
        if (supertype.name().equals((Object)subject.name())) {
            return true;
        }
        try {
            for (IType type : subject.types()) {
                if (!this.computeInstanceOf(type, supertype)) continue;
                return true;
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private boolean computeInstanceOf(IType type, JdtResolvedClass supertype) throws JavaModelException {
        String superclassSignature;
        if (supertype.isInterface()) {
            String[] stringArray = type.getSuperInterfaceTypeSignatures();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String superinterfaceSignature = stringArray[n2];
                String superinterfaceName = this.convertSignatureIntoName(superinterfaceSignature, type);
                Optional<JdtResolvedClass> superinterface = this.loadClass(new Name(superinterfaceName)).map(JdtResolvedClass.class::cast);
                if (superinterface.isPresent() && this.instanceOf(superinterface.get(), supertype)) {
                    return true;
                }
                ++n2;
            }
        }
        if ((superclassSignature = type.getSuperclassTypeSignature()) != null && !superclassSignature.equals("java.lang.Object")) {
            String superclassName = this.convertSignatureIntoName(superclassSignature, type);
            Optional<JdtResolvedClass> superclass = this.loadClass(new Name(superclassName)).map(JdtResolvedClass.class::cast);
            if (superclass.isPresent() && this.instanceOf(superclass.get(), supertype)) {
                return true;
            }
        }
        return false;
    }

    private String convertSignatureIntoName(String typeSignature, IType type) throws JavaModelException, IllegalArgumentException {
        String typeErasure = Signature.getTypeErasure((String)typeSignature);
        if (typeErasure.charAt(0) == 'Q') {
            String[][] resolvedName = type.resolveType(Signature.toString((String)typeErasure));
            if (resolvedName.length > 0) {
                return Signature.toQualifiedName((String[])resolvedName[0]);
            }
            return Signature.toString((String)typeErasure);
        }
        return Signature.toString((String)typeErasure);
    }
}

