/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import poussecafe.eclipse.plugin.builder.JavaSourceFileVisitor;
import poussecafe.eclipse.plugin.builder.JdtClassPathExplorer;
import poussecafe.eclipse.plugin.builder.JdtClassResolver;
import poussecafe.eclipse.plugin.builder.ResourceSource;
import poussecafe.eclipse.plugin.builder.Resources;
import poussecafe.eclipse.plugin.core.PousseCafeCore;
import poussecafe.eclipse.plugin.core.PousseCafeProject;
import poussecafe.source.Source;
import poussecafe.source.SourceScanner;
import poussecafe.source.analysis.ClassResolver;
import poussecafe.source.analysis.ResolvedCompilationUnitVisitor;
import poussecafe.source.analysis.SourceModelBuilderVisitor;
import poussecafe.source.analysis.TypeResolvingCompilationUnitVisitor;
import poussecafe.source.validation.SourceFileLine;
import poussecafe.source.validation.ValidationMessage;
import poussecafe.source.validation.ValidationMessageType;
import poussecafe.source.validation.ValidationModelBuilderVisitor;
import poussecafe.source.validation.ValidationResult;
import poussecafe.source.validation.Validator;

public class PousseCafeBuilder
extends IncrementalProjectBuilder {
    private static final String MARKER_TYPE = "poussecafe.eclipse.plugin.pousseCafeProblem";
    private ILog logger = Platform.getLog(((Object)((Object)this)).getClass());
    private JdtClassResolver classResolver;
    private IJavaProject javaProject;
    private ValidationModelBuilderVisitor validationVisitor;
    private SourceModelBuilderVisitor sourceModelVisitor;
    private SourceScanner scanner;
    private Map<String, IFile> files = new HashMap<String, IFile>();
    private Validator validator;
    public static final String BUILDER_ID = "poussecafe.eclipse.plugin.pousseCafeBuilder";

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.deleteProjectPousseCafeMarkers();
        this.clearBuilderState();
    }

    private void clearBuilderState() {
        this.scanner = null;
        this.files.clear();
    }

    private void deleteProjectPousseCafeMarkers() {
        try {
            this.getProject().deleteMarkers(MARKER_TYPE, true, 2);
        }
        catch (CoreException e) {
            this.logger.error("Unable to delete markers", (Throwable)e);
        }
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Pousse-Caf\u00e9 build: " + this.getProject().getName(), 4);
        if (this.scanner != null && (kind == 10 || kind == 9)) {
            monitor.subTask("Pousse-Caf\u00e9 build: incremental...");
            long start = System.currentTimeMillis();
            IResourceDelta delta = this.getDelta(this.getProject());
            List<IResourceDelta> updatedResources = this.relevantDeltas(delta);
            for (IResourceDelta source : updatedResources) {
                ResourceSource resource = new ResourceSource.Builder().file((IFile)source.getResource()).project(this.javaProject()).build();
                if (source.getKind() == 1 || source.getKind() == 4) {
                    this.includeFile(resource);
                    continue;
                }
                this.scanner.forget(resource.id());
            }
            long end = System.currentTimeMillis();
            this.logger.info("Scanned delta in " + (end - start) + " ms");
            monitor.worked(1);
        } else {
            monitor.subTask("Pousse-Caf\u00e9 build: full...");
            this.buildModels(monitor);
            monitor.worked(1);
        }
        monitor.subTask("Pousse-Caf\u00e9 build: validating...");
        this.validateProject();
        monitor.worked(2);
        monitor.subTask("Pousse-Caf\u00e9 build: refreshing model...");
        this.refreshPousseCafeProject();
        monitor.worked(3);
        monitor.subTask("Pousse-Caf\u00e9 build: refreshing markers...");
        this.refreshMarkers();
        monitor.worked(4);
        return new IProject[0];
    }

    private List<IResourceDelta> relevantDeltas(IResourceDelta delta) {
        ArrayList<IResourceDelta> updatedResources = new ArrayList<IResourceDelta>();
        this.changeTriggeringBuild(updatedResources, delta);
        return updatedResources;
    }

    private void changeTriggeringBuild(List<IResourceDelta> resources, IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (Resources.isJavaSourceFile(resource)) {
            resources.add(delta);
        } else {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.changeTriggeringBuild(resources, child);
                ++n2;
            }
        }
    }

    private void buildModels(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        this.classResolver = new JdtClassResolver(this.javaProject());
        this.validationVisitor = new ValidationModelBuilderVisitor();
        this.sourceModelVisitor = new SourceModelBuilderVisitor();
        this.scanner = new SourceScanner(new TypeResolvingCompilationUnitVisitor.Builder().withClassResolver((ClassResolver)this.classResolver).withVisitor((ResolvedCompilationUnitVisitor)this.sourceModelVisitor).withVisitor((ResolvedCompilationUnitVisitor)this.validationVisitor).build());
        this.files.clear();
        try {
            this.getProject().accept((IResourceVisitor)new ResourceVisitor(monitor));
        }
        catch (CoreException e) {
            this.logger.error("Unable to validate project", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        this.logger.info("Scanned project in " + (end - start) + " ms");
    }

    private IJavaProject javaProject() {
        if (this.javaProject == null) {
            this.javaProject = JavaCore.create((IProject)this.getProject());
        }
        return this.javaProject;
    }

    private void includeFile(ResourceSource source) {
        this.files.put(source.id(), source.file());
        try {
            this.scanner.includeSource((Source)source);
        }
        catch (Exception e) {
            this.logger.error("Error while scanning " + source.id(), (Throwable)e);
        }
    }

    private void validateProject() {
        this.validator = new Validator(this.validationVisitor.buildModel(), Optional.of(new JdtClassPathExplorer(this.classResolver)));
        this.validator.validate();
    }

    private void refreshPousseCafeProject() {
        PousseCafeProject pousseCafeProject = PousseCafeCore.getProject(this.javaProject);
        pousseCafeProject.refresh(this.sourceModelVisitor.buildModel());
    }

    private void refreshMarkers() {
        this.deleteProjectPousseCafeMarkers();
        ValidationResult result = this.validator.result();
        for (ValidationMessage message : result.messages()) {
            SourceFileLine location = message.location();
            IFile file = this.files.get(location.sourceFile().id());
            if (file != null) {
                this.addMarker(file, message.message(), location.line(), this.severity(message.type()));
                continue;
            }
            this.logger.error("Unknown file " + location.sourceFile().id());
        }
    }

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException e) {
            this.logger.error("Unable to add marker", (Throwable)e);
        }
    }

    private int severity(ValidationMessageType type) {
        if (type == ValidationMessageType.ERROR) {
            return 2;
        }
        if (type == ValidationMessageType.WARNING) {
            return 1;
        }
        return 0;
    }

    private class ResourceVisitor
    extends JavaSourceFileVisitor {
        private IProgressMonitor monitor;

        ResourceVisitor(IProgressMonitor monitor) {
            super(PousseCafeBuilder.this.javaProject());
            this.monitor = monitor;
        }

        @Override
        protected void visit(ResourceSource source) {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.monitor.subTask("Pousse-Caf\u00e9 build: scanning " + source.id());
            PousseCafeBuilder.this.includeFile(source);
        }
    }
}

