/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import poussecafe.source.Source;

public class ResourceSource
implements Source {
    private ICompilationUnit compilationUnit;
    private String id;
    private IFile file;

    public void configure(ASTParser parser) {
        parser.setSource(this.compilationUnit);
    }

    public ICompilationUnit compilationUnit() {
        return this.compilationUnit;
    }

    public String id() {
        return this.id;
    }

    public IFile file() {
        return this.file;
    }

    public String content() {
        return this.readAllChars();
    }

    private String readAllChars() {
        byte[] bytes;
        try {
            InputStream inputStream = this.file.getContents();
            bytes = inputStream.readAllBytes();
            inputStream.close();
        }
        catch (IOException | CoreException e) {
            throw new IllegalArgumentException("Unable to read path content", e);
        }
        return new String(bytes);
    }

    private ResourceSource() {
    }

    public static class Builder {
        private ResourceSource source = new ResourceSource();
        private IJavaProject project;

        public ResourceSource build() {
            Objects.requireNonNull(this.source.file);
            this.source.id = this.source.file.getFullPath().toString();
            Objects.requireNonNull(this.project);
            this.source.compilationUnit = (ICompilationUnit)JavaCore.create((IResource)this.source.file, (IJavaProject)this.project);
            return this.source;
        }

        public Builder file(IFile file) {
            this.source.file = file;
            return this;
        }

        public Builder project(IJavaProject project) {
            this.project = project;
            return this;
        }
    }
}

