/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import poussecafe.source.model.Model;

public class PousseCafeProject {
    private IJavaProject project;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private Model model;
    private boolean buildInProgress;
    private static final String PLUGIN_TEMP_FOLDER = ".pousse-cafe";

    PousseCafeProject(IJavaProject project) {
        Objects.requireNonNull(project);
        this.project = project;
    }

    public IJavaProject getJavaProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChangeListener listener) {
        PousseCafeProject pousseCafeProject = this;
        synchronized (pousseCafeProject) {
            this.listeners.add(listener);
        }
        if (this.model().isPresent()) {
            listener.consume(this);
        } else {
            this.triggerPousseCafeBuilder();
        }
    }

    private synchronized void triggerPousseCafeBuilder() {
        if (!this.buildInProgress) {
            Job job = Job.create((String)("Build Pousse-Caf\u00e9 project " + this.project.getProject().getName()), this::buildPousseCafeProject);
            job.schedule();
            this.buildInProgress = true;
        }
    }

    private void buildPousseCafeProject(IProgressMonitor monitor) throws CoreException {
        this.project.getProject().build(6, "poussecafe.eclipse.plugin.pousseCafeBuilder", null, monitor);
    }

    public synchronized void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Model model) {
        PousseCafeProject pousseCafeProject = this;
        synchronized (pousseCafeProject) {
            Objects.requireNonNull(model);
            this.model = model;
            this.buildInProgress = false;
        }
        for (ChangeListener listener : this.listeners) {
            listener.consume(this);
        }
    }

    public synchronized Optional<Model> model() {
        return Optional.ofNullable(this.model);
    }

    public IFile createTempFile(String fileName) throws CoreException {
        IFolder tempFolder = this.project.getJavaProject().getProject().getFolder(PLUGIN_TEMP_FOLDER);
        tempFolder.refreshLocal(2, null);
        if (!tempFolder.exists()) {
            tempFolder.create(false, true, null);
        }
        IFile tempFile = tempFolder.getFile(fileName);
        tempFile.refreshLocal(0, null);
        return tempFile;
    }

    @FunctionalInterface
    public static interface ChangeListener {
        public void consume(PousseCafeProject var1);
    }
}

