/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.editors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import poussecafe.eclipse.plugin.actions.OpenEmilEditorAction;
import poussecafe.eclipse.plugin.actions.OpenJavaEditorAction;
import poussecafe.eclipse.plugin.builder.ResourceSource;
import poussecafe.eclipse.plugin.editors.ActionHyperlink;
import poussecafe.eclipse.plugin.editors.EmilEditor;
import poussecafe.eclipse.plugin.editors.EmilStringParser;
import poussecafe.eclipse.plugin.editors.RegionQueries;
import poussecafe.source.Source;
import poussecafe.source.emil.parser.EmilParser;
import poussecafe.source.generation.NamingConventions;
import poussecafe.source.model.Aggregate;
import poussecafe.source.model.Command;
import poussecafe.source.model.DomainEvent;
import poussecafe.source.model.MessageListener;
import poussecafe.source.model.MessageListenerContainerType;
import poussecafe.source.model.Model;
import poussecafe.source.model.ProcessModel;
import poussecafe.source.model.Runner;

public class EmilHyperlinkDetector
extends AbstractHyperlinkDetector {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private EmilEditor editor;
    private EmilParser.ProcessContext tree;
    private List<IHyperlink> links;
    private IRegion region;
    private static final Set<String> HOOK_NAMES = new HashSet<String>();

    static {
        HOOK_NAMES.add("onAdd");
        HOOK_NAMES.add("onDelete");
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        this.logger.debug("Detecting links at {}", (Object)region.getOffset());
        IEditorInput editorInput = this.editor.getEditorInput();
        Optional<Model> optionalModel = this.editor.getPousseCafeProject().model();
        if (optionalModel.isEmpty()) {
            return null;
        }
        IDocumentProvider documentProvider = this.editor.getDocumentProvider();
        IDocument document = documentProvider.getDocument((Object)editorInput);
        EmilStringParser parser = new EmilStringParser(document.get());
        if (parser.errors().isEmpty()) {
            this.tree = parser.tree();
            this.links = new ArrayList<IHyperlink>();
            this.region = region;
            this.findLinks();
            if (this.links.isEmpty()) {
                this.logger.debug("Found 0 links");
                return null;
            }
            IHyperlink[] linksArray = new IHyperlink[this.links.size()];
            return this.links.toArray(linksArray);
        }
        return null;
    }

    private void findLinks() {
        this.tryAddLinksOfHeader(this.tree.header());
        this.tryAddLinksOfConsumptions(this.tree.consumptions());
    }

    private void tryAddLinksOfHeader(EmilParser.HeaderContext header) {
        TerminalNode processName = header.NAME();
        Optional<ProcessModel> process = this.modelOrElseThrow().processes().stream().filter(candidate -> candidate.simpleName().equals(processName.getText())).findFirst();
        this.tryAddLink(processName.getSymbol(), process.map(ProcessModel::source).map(Optional::of), unit -> Optional.of(unit.getType(processName.getText())));
    }

    private Model modelOrElseThrow() {
        return this.editor.getPousseCafeProject().model().orElseThrow();
    }

    private void tryAddLink(Token node, Optional<Optional<Source>> sourceContainer, Function<ICompilationUnit, Optional<IMember>> memberExtractor) {
        ResourceSource source;
        ICompilationUnit compilationUnit;
        Optional<IMember> member;
        IRegion linkRegion = this.region(node);
        if (new RegionQueries(linkRegion).contains(this.region) && sourceContainer.isPresent() && sourceContainer.get().isPresent() && (member = memberExtractor.apply(compilationUnit = (source = (ResourceSource)sourceContainer.get().orElseThrow()).compilationUnit())).isPresent() && member.get().exists()) {
            this.logger.debug("Found link with region {}..{}", (Object)linkRegion.getOffset(), (Object)(linkRegion.getOffset() + linkRegion.getLength() - 1));
            OpenJavaEditorAction openJavaEditor = new OpenJavaEditorAction.Builder().site((IWorkbenchSite)this.editor.getSite()).member(member.get()).build();
            this.links.add(new ActionHyperlink.Builder().region(linkRegion).name(member.get().getElementName()).action(openJavaEditor).build());
        }
    }

    private void tryAddLinksOfConsumptions(EmilParser.ConsumptionsContext consumptions) {
        for (EmilParser.ConsumptionContext consumption : consumptions.consumption()) {
            this.tryAddLinksOfCommandConsumption(consumption);
            this.tryAddLinksOfEventConsumption(consumption);
        }
    }

    private void tryAddLinksOfCommandConsumption(EmilParser.ConsumptionContext consumption) {
        EmilParser.CommandConsumptionContext commandConsumption = consumption.commandConsumption();
        if (commandConsumption != null) {
            TerminalNode commandName = commandConsumption.command().NAME();
            Optional command = this.modelOrElseThrow().command(commandName.getText());
            this.tryAddLink(commandName.getSymbol(), command.map(Command::source), unit -> Optional.of(unit.getType(commandName.getText())));
            this.tryAddLinks(commandName.getText(), commandConsumption.messageConsumptions());
        }
    }

    private void tryAddLinks(String messageTypeName, EmilParser.MessageConsumptionsContext messageConsumptions) {
        if (messageConsumptions.multipleMessageConsumptions() != null) {
            for (EmilParser.MultipleMessageConsumptionsItemContext item : messageConsumptions.multipleMessageConsumptions().multipleMessageConsumptionsItem()) {
                this.tryAddLinks(messageTypeName, item);
            }
        } else if (messageConsumptions.singleMessageConsumption() != null) {
            this.tryAddLinks(messageTypeName, messageConsumptions.singleMessageConsumption());
        }
    }

    private void tryAddLinks(String messageTypeName, EmilParser.MultipleMessageConsumptionsItemContext item) {
        this.tryAddLinks(messageTypeName, item.singleMessageConsumption());
    }

    private void tryAddLinks(String messageTypeName, EmilParser.SingleMessageConsumptionContext singleMessageConsumption) {
        if (singleMessageConsumption.factoryConsumption() != null) {
            this.tryAddLinks(messageTypeName, singleMessageConsumption.factoryConsumption());
        } else if (singleMessageConsumption.aggregateRootConsumption() != null) {
            this.tryAddLinks(messageTypeName, singleMessageConsumption.aggregateRootConsumption());
        } else if (singleMessageConsumption.repositoryConsumption() != null) {
            this.tryAddLinks(messageTypeName, singleMessageConsumption.repositoryConsumption());
        } else if (singleMessageConsumption.processConsumption() != null) {
            this.tryAddLinks(singleMessageConsumption.processConsumption());
        }
    }

    private void tryAddLinks(String messageTypeName, EmilParser.FactoryConsumptionContext factoryConsumption) {
        this.tryAddLinks(messageTypeName, factoryConsumption.factoryListener());
        this.tryAddLinks(factoryConsumption.aggregateRoot());
        if (factoryConsumption.aggregateRoot() != null) {
            this.tryAddLinkListener(factoryConsumption.aggregateRoot().qualifiedRootName, factoryConsumption.aggregateRoot().simpleRootName, this.hookNameToken((ParserRuleContext)factoryConsumption, "onAdd"), null, factoryConsumption.aggregateRoot().simpleRootName != null ? MessageListenerContainerType.STANDALONE_ROOT : MessageListenerContainerType.INNER_ROOT);
            this.tryAddLinks(factoryConsumption.eventProductions());
        }
    }

    private Token hookNameToken(ParserRuleContext rule, String hookName) {
        int i = 0;
        while (i < rule.getChildCount()) {
            TerminalNode terminalNode;
            ParseTree child = rule.getChild(i);
            if (child instanceof TerminalNode && (terminalNode = (TerminalNode)child).getText().equals(hookName)) {
                return terminalNode.getSymbol();
            }
            ++i;
        }
        throw new IllegalArgumentException("Hook token " + hookName + " not found");
    }

    private void tryAddLinks(String messageTypeName, EmilParser.FactoryListenerContext factoryListener) {
        if (factoryListener.qualifiedName() != null) {
            this.tryAddLinksOfAggregateContainer(factoryListener.qualifiedName());
        } else {
            this.tryAddLinkStandaloneComponent(factoryListener.simpleFactoryName, NamingConventions::aggregateNameFromSimpleFactoryName, aggregate -> aggregate.map(Aggregate::standaloneFactorySource));
        }
        this.tryAddLinkListener(factoryListener.qualifiedFactoryName, factoryListener.simpleFactoryName, factoryListener.listenerName, messageTypeName, factoryListener.simpleFactoryName != null ? MessageListenerContainerType.STANDALONE_FACTORY : MessageListenerContainerType.INNER_FACTORY);
    }

    private void tryAddLinksOfAggregateContainer(EmilParser.QualifiedNameContext qualifiedName) {
        TerminalNode aggregateNameNode = qualifiedName.NAME(0);
        String aggregateName = aggregateNameNode.getText();
        Optional<Optional<Source>> source = this.aggregateContainer(qualifiedName);
        this.tryAddLink(aggregateNameNode.getSymbol(), source, unit -> Optional.of(unit.getType(aggregateName)));
        TerminalNode typeNameNode = qualifiedName.NAME(1);
        this.tryAddLink(typeNameNode.getSymbol(), source, unit -> Optional.of(unit.getType(aggregateName).getType(typeNameNode.getText())));
    }

    private void tryAddLinkStandaloneComponent(Token simpleName, UnaryOperator<String> aggregateNameProvider, Function<Optional<Aggregate>, Optional<Optional<Source>>> sourceProvider) {
        String className = simpleName.getText();
        String aggregateName = (String)aggregateNameProvider.apply(className);
        Optional aggregate = this.modelOrElseThrow().aggregate(aggregateName);
        this.tryAddLink(simpleName, sourceProvider.apply(aggregate), unit -> Optional.of(unit.getType(className)));
    }

    private void tryAddLinkListener(EmilParser.QualifiedNameContext containerQualifiedName, Token containerSimpleName, Token listenerName, String messageTypeName, MessageListenerContainerType containerType) {
        Optional<Optional<Source>> listenerContainer = this.listenerContainer(containerQualifiedName, containerSimpleName, containerType);
        Function<ICompilationUnit, Optional<IMember>> listenerExtractor = this.listenerExtractor(containerQualifiedName, containerSimpleName, listenerName.getText(), messageTypeName);
        this.tryAddLink(listenerName, listenerContainer, listenerExtractor);
    }

    private Optional<Optional<Source>> listenerContainer(EmilParser.QualifiedNameContext qualifiedName, Token simpleName, MessageListenerContainerType containerType) {
        if (qualifiedName != null) {
            return this.aggregateContainer(qualifiedName);
        }
        try {
            if (containerType == MessageListenerContainerType.STANDALONE_ROOT) {
                String aggregateName = NamingConventions.aggregateNameFromSimpleRootName((String)simpleName.getText());
                Optional aggregate = this.modelOrElseThrow().aggregate(aggregateName);
                return aggregate.map(Aggregate::standaloneRootSource);
            }
            if (containerType == MessageListenerContainerType.STANDALONE_FACTORY) {
                String aggregateName = NamingConventions.aggregateNameFromSimpleFactoryName((String)simpleName.getText());
                Optional aggregate = this.modelOrElseThrow().aggregate(aggregateName);
                return aggregate.map(Aggregate::standaloneFactorySource);
            }
            if (containerType == MessageListenerContainerType.STANDALONE_REPOSITORY) {
                String aggregateName = NamingConventions.aggregateNameFromSimpleRepositoryName((String)simpleName.getText());
                Optional aggregate = this.modelOrElseThrow().aggregate(aggregateName);
                return aggregate.map(Aggregate::standaloneRepositorySource);
            }
            return Optional.empty();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    private Optional<Optional<Source>> aggregateContainer(EmilParser.QualifiedNameContext qualifiedName) {
        Optional<Aggregate> aggregate = this.aggregate(qualifiedName);
        return aggregate.map(Aggregate::containerSource);
    }

    private Optional<Aggregate> aggregate(EmilParser.QualifiedNameContext qualifiedName) {
        TerminalNode aggregateNameNode = qualifiedName.NAME(0);
        String aggregateName = aggregateNameNode.getText();
        return this.modelOrElseThrow().aggregate(aggregateName);
    }

    private Function<ICompilationUnit, Optional<IMember>> listenerExtractor(EmilParser.QualifiedNameContext qualifiedName, Token simpleName, String methodName, String messageTypeName) {
        return unit -> {
            IType listenerContainer = qualifiedName != null ? unit.getType(qualifiedNameContext.qualifier.getText()).getType(qualifiedNameContext.name.getText()) : unit.getType(simpleName.getText());
            if (listenerContainer.exists()) {
                IMethod method = HOOK_NAMES.contains(methodName) ? listenerContainer.getMethod(methodName, new String[0]) : listenerContainer.getMethod(methodName, new String[]{Signature.createTypeSignature((String)messageTypeName, (boolean)false)});
                return Optional.of(method);
            }
            return Optional.empty();
        };
    }

    private void tryAddLinks(EmilParser.AggregateRootContext aggregateRoot) {
        if (aggregateRoot != null) {
            if (aggregateRoot.qualifiedName() != null) {
                this.tryAddLinksOfAggregateContainer(aggregateRoot.qualifiedName());
            } else {
                this.tryAddLinkStandaloneComponent(aggregateRoot.simpleRootName, NamingConventions::aggregateNameFromSimpleRootName, aggregate -> aggregate.map(Aggregate::standaloneRootSource));
            }
        }
    }

    private void tryAddLinks(EmilParser.EventProductionsContext eventProductions) {
        if (eventProductions != null) {
            for (EmilParser.EventProductionContext eventProduction : eventProductions.eventProduction()) {
                this.tryAddLinks(eventProduction);
            }
        }
    }

    private void tryAddLinks(EmilParser.EventProductionContext eventProduction) {
        this.tryAddLinkEvent(eventProduction.event());
        this.tryAddLinks(eventProduction.event().NAME().getText(), eventProduction.messageConsumptions());
    }

    private void tryAddLinkEvent(EmilParser.EventContext event) {
        TerminalNode eventName = event.NAME();
        Optional domainEvent = this.modelOrElseThrow().event(eventName.getText());
        this.tryAddLink(eventName.getSymbol(), domainEvent.map(DomainEvent::source), unit -> Optional.of(unit.getType(eventName.getText())));
    }

    private void tryAddLinks(String messageTypeName, EmilParser.AggregateRootConsumptionContext aggregateRootConsumption) {
        this.tryAddLinks(aggregateRootConsumption.aggregateRoot());
        String aggregateName = this.aggregateName(aggregateRootConsumption.aggregateRoot());
        Optional<MessageListener> listener = this.modelOrElseThrow().aggregateListeners(aggregateName).stream().filter(candidate -> candidate.methodName().equals(aggregateRootConsumptionContext.listenerName.getText())).filter(candidate -> candidate.consumedMessage().name().equals(messageTypeName)).findFirst();
        if (listener.isPresent() && listener.get().runnerClass().isPresent()) {
            Optional runner = this.modelOrElseThrow().runner((String)listener.get().runnerClass().orElseThrow());
            this.tryAddLink(aggregateRootConsumption.runnerName, runner.map(Runner::runnerSource).map(Optional::of), unit -> Optional.of(unit.getType(aggregateRootConsumptionContext.runnerName.getText())));
        }
        this.tryAddLinkListener(aggregateRootConsumption.aggregateRoot().qualifiedRootName, aggregateRootConsumption.aggregateRoot().simpleRootName, aggregateRootConsumption.listenerName, messageTypeName, aggregateRootConsumption.aggregateRoot().simpleRootName != null ? MessageListenerContainerType.STANDALONE_ROOT : MessageListenerContainerType.INNER_ROOT);
        this.tryAddLinks(aggregateRootConsumption.eventProductions());
    }

    private String aggregateName(EmilParser.AggregateRootContext aggregateRoot) {
        if (aggregateRoot.qualifiedRootName != null) {
            return aggregateRoot.qualifiedRootName.qualifier.getText();
        }
        return NamingConventions.aggregateNameFromSimpleRootName((String)aggregateRoot.simpleRootName.getText());
    }

    private void tryAddLinks(String messageTypeName, EmilParser.RepositoryConsumptionContext repositoryConsumption) {
        this.tryAddLinksOfName(repositoryConsumption);
        this.tryAddLinkListener(repositoryConsumption.qualifiedRepositoryName, repositoryConsumption.simpleRepositoryName, repositoryConsumption.listenerName, messageTypeName, repositoryConsumption.simpleRepositoryName != null ? MessageListenerContainerType.STANDALONE_REPOSITORY : MessageListenerContainerType.INNER_REPOSITORY);
        if (repositoryConsumption.aggregateRoot() != null) {
            this.tryAddLinks(repositoryConsumption.aggregateRoot());
            this.tryAddLinkListener(repositoryConsumption.aggregateRoot().qualifiedRootName, repositoryConsumption.aggregateRoot().simpleRootName, this.hookNameToken((ParserRuleContext)repositoryConsumption, "onDelete"), null, repositoryConsumption.aggregateRoot().simpleRootName != null ? MessageListenerContainerType.STANDALONE_ROOT : MessageListenerContainerType.INNER_ROOT);
            this.tryAddLinks(repositoryConsumption.eventProductions());
        }
    }

    private void tryAddLinksOfName(EmilParser.RepositoryConsumptionContext repositoryConsumption) {
        if (repositoryConsumption.qualifiedName() != null) {
            this.tryAddLinksOfAggregateContainer(repositoryConsumption.qualifiedName());
        } else {
            this.tryAddLinkStandaloneComponent(repositoryConsumption.simpleRepositoryName, NamingConventions::aggregateNameFromSimpleRepositoryName, aggregate -> aggregate.map(Aggregate::standaloneRepositorySource));
        }
    }

    private void tryAddLinks(EmilParser.ProcessConsumptionContext processConsumption) {
        TerminalNode processNameToken = processConsumption.NAME();
        IRegion linkRegion = this.region(processNameToken.getSymbol());
        if (new RegionQueries(linkRegion).contains(this.region)) {
            this.logger.debug("Found link with region {}..{}", (Object)linkRegion.getOffset(), (Object)(linkRegion.getOffset() + linkRegion.getLength() - 1));
            String processName = processNameToken.getText();
            OpenEmilEditorAction openEmilEditor = new OpenEmilEditorAction.Builder().processName(processName).project(this.editor.getPousseCafeProject()).workbenchWindow(this.editor.getSite().getWorkbenchWindow()).build();
            ActionHyperlink link = new ActionHyperlink.Builder().region(linkRegion).action(openEmilEditor).name(processName).build();
            this.links.add(link);
        }
    }

    private void tryAddLinksOfEventConsumption(EmilParser.ConsumptionContext consumption) {
        EmilParser.EventConsumptionContext eventConsumption = consumption.eventConsumption();
        if (eventConsumption != null) {
            this.tryAddLinkEvent(eventConsumption.event());
            this.tryAddLinks(eventConsumption.event().NAME().getText(), eventConsumption.messageConsumptions());
        }
    }

    private IRegion region(Token token) {
        return new Region(token.getStartIndex(), token.getStopIndex() - token.getStartIndex() + 1);
    }

    public EmilHyperlinkDetector(EmilEditor editor) {
        this.editor = editor;
    }
}

