/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.eclipse.jface.text.Position;
import poussecafe.source.emil.parser.EmilLexer;
import poussecafe.source.emil.parser.EmilParser;

public class EmilStringParser {
    private EmilParser.ProcessContext tree;
    private ANTLRErrorListener errorListener = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            Position position = null;
            if (offendingSymbol instanceof Token) {
                Token token = (Token)offendingSymbol;
                position = new Position(token.getStartIndex(), token.getStopIndex() - token.getStartIndex() + 1);
            }
            Error error = new Error();
            error.position = position;
            error.message = msg;
            EmilStringParser.this.errors.add(error);
        }
    };
    private List<Error> errors = new ArrayList<Error>();

    public EmilStringParser(String emilText) {
        CodePointCharStream stream = CharStreams.fromString((String)emilText);
        EmilLexer lexer = new EmilLexer((CharStream)stream);
        lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        lexer.addErrorListener(this.errorListener);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        EmilParser parser = new EmilParser((TokenStream)tokenStream);
        parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        parser.addErrorListener(this.errorListener);
        this.tree = parser.process();
    }

    public EmilParser.ProcessContext tree() {
        return this.tree;
    }

    public List<Error> errors() {
        return Collections.unmodifiableList(this.errors);
    }

    public static class Error {
        private Position position;
        private String message;

        public Position position() {
            return this.position;
        }

        public String message() {
            return this.message;
        }

        private Error() {
        }
    }
}

