/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import poussecafe.source.Source;

public class ResourceSource
extends Source
implements Serializable {
    private transient ICompilationUnit compilationUnit;
    private transient IFile file;
    private transient IJavaProject project;

    public void configure(ASTParser parser) {
        parser.setSource(this.resourceCompilationUnit());
    }

    public ICompilationUnit resourceCompilationUnit() {
        this.connectedOrThrow();
        if (this.compilationUnit == null) {
            this.compilationUnit = (ICompilationUnit)JavaCore.create((IResource)this.file(), (IJavaProject)this.project);
        }
        return this.compilationUnit;
    }

    private void connectedOrThrow() {
        if (this.project == null) {
            throw new IllegalStateException("Connect resource to a project");
        }
    }

    public IFile file() {
        this.connectedOrThrow();
        if (this.file == null) {
            Path path = new Path(this.id());
            this.file = this.project.getProject().getFile((IPath)path);
        }
        return this.file;
    }

    public void connect(Object project) {
        Objects.requireNonNull(project);
        this.project = (IJavaProject)project;
    }

    public ResourceSource(IFile file) {
        super(file.getProjectRelativePath().toString());
    }

    ResourceSource() {
    }
}

