/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.views;

import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import poussecafe.eclipse.plugin.actions.OpenEmilEditorAction;
import poussecafe.eclipse.plugin.builder.PousseCafeNature;
import poussecafe.eclipse.plugin.core.PousseCafeCore;
import poussecafe.eclipse.plugin.core.PousseCafeProject;
import poussecafe.source.model.ComponentWithType;

public class ProcessListView
extends ViewPart {
    public static final String ID = "poussecafe.eclipse.plugin.views.ProcessListView";
    @Inject
    IWorkbench workbench;
    private TableViewer viewer;
    private ISelectionListener selectionListener = (part, selection) -> {
        TreeSelection packageSelection;
        if (part instanceof IPackagesViewPart && selection instanceof TreeSelection && !selection.isEmpty() && (packageSelection = (TreeSelection)selection).getFirstElement() instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)packageSelection.getFirstElement();
            this.setProject(javaProject);
        }
    };
    private PousseCafeProject currentProject;
    private ProjectListener projectListener = new ProjectListener();

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.clearList();
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
        this.registerDoubleClickAction();
        this.fillActionBar();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
        super.dispose();
    }

    private void setProject(IJavaProject javaProject) {
        PousseCafeProject newProject;
        if (PousseCafeNature.isPousseCafeProject(javaProject) && this.currentProject != (newProject = PousseCafeCore.getProject(javaProject))) {
            this.clearList();
            if (this.currentProject != null) {
                this.currentProject.removeListener(this.projectListener);
            }
            this.currentProject = newProject;
            this.currentProject.addListener(this.projectListener);
        }
    }

    private void clearList() {
        this.viewer.setInput((Object)new String[0]);
    }

    private void refreshProcessList() {
        final String[] processNames = (String[])this.currentProject.model().orElseThrow().processes().stream().map(ComponentWithType::simpleName).sorted().toArray(String[]::new);
        UIJob uiJob = new UIJob("Refresh process list"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ProcessListView.this.viewer.setInput((Object)processNames);
                return Status.OK_STATUS;
            }
        };
        uiJob.schedule();
    }

    private void registerDoubleClickAction() {
        Action doubleClickAction = new Action(){

            public void run() {
                IStructuredSelection selection = ProcessListView.this.viewer.getStructuredSelection();
                String processName = (String)selection.getFirstElement();
                OpenEmilEditorAction openEmilEditor = new OpenEmilEditorAction.Builder().processName(processName).project(ProcessListView.this.currentProject).workbenchWindow(ProcessListView.this.getSite().getWorkbenchWindow()).build();
                openEmilEditor.run();
            }
        };
        this.viewer.addDoubleClickListener(arg_0 -> ProcessListView.lambda$3(doubleClickAction, arg_0));
    }

    private void fillActionBar() {
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        IAction refreshListAction = this.buildRefreshListAction();
        toolBar.add(refreshListAction);
    }

    private IAction buildRefreshListAction() {
        Action action = new Action(){

            public void run() {
                if (ProcessListView.this.currentProject != null && ProcessListView.this.currentProject.model().isPresent()) {
                    ProcessListView.this.refreshProcessList();
                }
            }
        };
        action.setText("Reload");
        action.setToolTipText("Reload process list");
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
        return action;
    }

    private static /* synthetic */ void lambda$3(2 var0, DoubleClickEvent event) {
        var0.run();
    }

    private class ProjectListener
    implements PousseCafeProject.ChangeListener {
        private ProjectListener() {
        }

        @Override
        public void consume(PousseCafeProject project) {
            if (project.equals(ProcessListView.this.currentProject)) {
                ProcessListView.this.refreshProcessList();
            }
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return ProcessListView.this.workbench.getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

