/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.core;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import poussecafe.source.analysis.ClassName;

public class JavaNameResolver {
    public static String resolveSignature(IType type, String typeSignature) throws JavaModelException, IllegalArgumentException {
        String typeErasure = Signature.getTypeErasure((String)typeSignature);
        if (typeErasure.charAt(0) == 'Q') {
            String resolvedName = JavaNameResolver.resolve(type, Signature.toString((String)typeErasure));
            if (resolvedName != null) {
                return resolvedName;
            }
            return Signature.toString((String)typeErasure);
        }
        return Signature.toString((String)typeErasure);
    }

    public static String resolve(IType type, String typeName) throws JavaModelException, IllegalArgumentException {
        String[][] resolvedName = type.resolveType(typeName);
        if (resolvedName != null && resolvedName.length > 0) {
            return Signature.toQualifiedName((String[])resolvedName[0]);
        }
        return null;
    }

    public static String simpleName(String typeSignature) {
        String typeErasure = Signature.getTypeErasure((String)typeSignature);
        String nameString = Signature.toString((String)typeErasure);
        return new ClassName(nameString).simple();
    }

    private JavaNameResolver() {
    }
}

