/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.core;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import poussecafe.eclipse.plugin.builder.JdtClassResolver;
import poussecafe.eclipse.plugin.builder.PousseCafeNature;
import poussecafe.eclipse.plugin.properties.PousseCafeProjectPropertyPage;
import poussecafe.source.analysis.ClassResolver;
import poussecafe.source.model.SourceModel;

public class PousseCafeProject
implements IAdaptable {
    private IJavaProject project;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private SourceModel model;
    private boolean initialBuildTriggered;
    private static final String PLUGIN_TEMP_FOLDER = ".pousse-cafe";

    public static boolean isPousseCafeProjectCompilationUnit(IFile file) {
        ICompilationUnit compilationUnit = (ICompilationUnit)JavaCore.create((IFile)file);
        if (compilationUnit == null) {
            return false;
        }
        IType type = compilationUnit.findPrimaryType();
        if (type == null) {
            return false;
        }
        IJavaProject javaProject = type.getJavaProject();
        return PousseCafeNature.isPousseCafeProject(javaProject);
    }

    PousseCafeProject(IJavaProject project) {
        Objects.requireNonNull(project);
        if (!PousseCafeNature.isPousseCafeProject(project)) {
            throw new IllegalArgumentException("Not a Pousse-Caf\u00e9 project");
        }
        this.project = project;
    }

    public IJavaProject getJavaProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChangeListener listener) {
        PousseCafeProject pousseCafeProject = this;
        synchronized (pousseCafeProject) {
            this.listeners.add(listener);
        }
        if (this.model().isPresent()) {
            listener.consume(this);
        } else {
            this.triggerInitialBuild();
        }
    }

    public synchronized void triggerInitialBuild() {
        if (!this.initialBuildTriggered) {
            Job job = Job.create((String)("Initial build of " + this.project.getProject().getName()), this::buildPousseCafeProject);
            job.schedule();
            this.initialBuildTriggered = true;
        }
    }

    private void buildPousseCafeProject(IProgressMonitor monitor) throws CoreException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("tryIncrementalFirst", "true");
        this.project.getProject().build(6, "poussecafe.eclipse.plugin.pousseCafeBuilder", args, monitor);
    }

    public synchronized void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(SourceModel model) {
        PousseCafeProject pousseCafeProject = this;
        synchronized (pousseCafeProject) {
            Objects.requireNonNull(model);
            this.model = model;
        }
        for (ChangeListener listener : this.listeners) {
            listener.consume(this);
        }
    }

    public synchronized Optional<SourceModel> model() {
        return Optional.ofNullable(this.model);
    }

    public IFile createTempFile(String fileName) throws CoreException {
        IFolder tempFolder = this.createPousseCafeTempFolder();
        IFile tempFile = tempFolder.getFile(fileName);
        tempFile.refreshLocal(0, null);
        return tempFile;
    }

    private IFolder createPousseCafeTempFolder() throws CoreException {
        IFolder tempFolder = this.project.getJavaProject().getProject().getFolder(PLUGIN_TEMP_FOLDER);
        tempFolder.refreshLocal(2, null);
        if (!tempFolder.exists()) {
            tempFolder.create(false, true, null);
        }
        return tempFolder;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IResource.class)) {
            return (T)this.project.getProject();
        }
        return null;
    }

    public String getBasePackage() {
        return this.getProperty(PousseCafeProjectPropertyPage.BASE_PACKAGE_PROPERTY_NAME, "default.base.package");
    }

    private String getProperty(QualifiedName name, String defaultValue) {
        IProject resource = this.project.getProject();
        try {
            return resource.getPersistentProperty(name);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    public Path getSourceFolder() {
        String relativeSourceFolder = this.getProperty(PousseCafeProjectPropertyPage.SOURCE_FOLDER_PROPERTY_NAME, "src/");
        return Path.of(this.project.getProject().getRawLocation().toOSString(), relativeSourceFolder);
    }

    public ClassResolver buildClassResolver() {
        return new JdtClassResolver(this.getJavaProject());
    }

    public boolean usesInternalStorage() {
        String value = this.getProperty(PousseCafeProjectPropertyPage.USES_INTERNAL_STORAGE_PROPERTY_NAME, "true");
        return Boolean.parseBoolean(value);
    }

    public boolean usesSpringMongoStorage() {
        String value = this.getProperty(PousseCafeProjectPropertyPage.USES_SPRING_MONGO_STORAGE_PROPERTY_NAME, "false");
        return Boolean.parseBoolean(value);
    }

    public boolean usesSpringJpaStorage() {
        String value = this.getProperty(PousseCafeProjectPropertyPage.USES_SPRING_JPA_STORAGE_PROPERTY_NAME, "false");
        return Boolean.parseBoolean(value);
    }

    public IFile builderStateFile() throws CoreException {
        IFolder tempFolder = this.createPousseCafeTempFolder();
        IFile file = tempFolder.getFile("builderState.dat");
        file.refreshLocal(0, null);
        return file;
    }

    public boolean hasProblems() throws CoreException {
        IMarker[] problems = this.project.getProject().findMarkers("poussecafe.eclipse.plugin.pousseCafeProblem", true, 2);
        return problems != null && problems.length > 0;
    }

    @FunctionalInterface
    public static interface ChangeListener {
        public void consume(PousseCafeProject var1);
    }
}

