/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import poussecafe.eclipse.plugin.builder.JdtClassResolver;
import poussecafe.eclipse.plugin.builder.ResourceSource;
import poussecafe.source.Source;
import poussecafe.source.analysis.ClassName;
import poussecafe.source.analysis.ClassResolver;
import poussecafe.source.analysis.ResolvedClass;
import poussecafe.util.Equality;

public class JdtResolvedClass
implements ResolvedClass {
    private static final char JDT_INNER_CLASS_SEPARATOR = '$';
    private Set<IType> types = new HashSet<IType>();
    private String jdtName;
    private ClassName javaName;
    private JdtClassResolver resolver;

    public Optional<ResolvedClass> declaringClass() {
        if (this.isInnerClass()) {
            List<IType> declaringClassesTypes = this.declaringTypes(this.jdtName);
            if (declaringClassesTypes.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(this.resolver.resolve(declaringClassesTypes));
        }
        return Optional.empty();
    }

    private boolean isInnerClass() {
        return this.jdtName.indexOf(36) != -1;
    }

    private List<IType> declaringTypes(String fullyQualifiedName) {
        try {
            int declaringClassNameEnd = this.declaringClassNameEnd(fullyQualifiedName);
            return this.resolver.loadType(fullyQualifiedName.substring(0, declaringClassNameEnd));
        }
        catch (ClassNotFoundException e) {
            Platform.getLog(this.getClass()).error("Unable to get declaring class of " + fullyQualifiedName, (Throwable)e);
            return Collections.emptyList();
        }
    }

    private int declaringClassNameEnd(String fullyQualifiedName) {
        int i = fullyQualifiedName.length() - 1;
        while (i >= 0) {
            if (fullyQualifiedName.charAt(i) == '$') {
                return i;
            }
            --i;
        }
        return -1;
    }

    public Set<IType> types() {
        return this.types;
    }

    public List<ResolvedClass> innerClasses() {
        HashMap<String, List> innerTypes = new HashMap<String, List>();
        for (IType type : this.types) {
            try {
                List typeInnerTypes = Arrays.stream(type.getTypes()).filter(this::isResolvableType).collect(Collectors.toList());
                for (IType innerType : typeInnerTypes) {
                    List innerTypeTypes = innerTypes.computeIfAbsent(innerType.getFullyQualifiedName(), name -> new ArrayList());
                    innerTypeTypes.add(innerType);
                }
            }
            catch (JavaModelException e) {
                this.logError("Unable to extract inner classes", (Exception)((Object)e));
            }
        }
        return innerTypes.values().stream().map(innerTypesClasses -> this.resolver.resolve((Collection<IType>)innerTypesClasses)).collect(Collectors.toList());
    }

    private void logError(String message, Exception e) {
        Platform.getLog(this.getClass()).error(message, (Throwable)e);
    }

    private boolean isResolvableType(IType candidate) {
        try {
            return candidate.isClass() || candidate.isInterface() || candidate.isEnum();
        }
        catch (JavaModelException e) {
            this.logError("Unable to extract inner classes", (Exception)((Object)e));
            return false;
        }
    }

    public boolean instanceOf(String name) throws ClassNotFoundException {
        JdtResolvedClass consideredType = this.resolver.loadClass(name);
        return this.instanceOf(consideredType);
    }

    private boolean instanceOf(JdtResolvedClass resolvedClass) {
        return this.resolver.instanceOf(this, resolvedClass);
    }

    public ClassName name() {
        return this.javaName;
    }

    public ClassResolver resolver() {
        return this.resolver;
    }

    public Optional<Object> staticFieldValue(String constantName) {
        Set values = this.types.stream().map(type -> type.getField(constantName)).map(this::getConstant).collect(Collectors.toSet());
        if (values.size() > 1) {
            throw new IllegalStateException("Conflicting values for constant " + constantName);
        }
        if (values.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(values.iterator().next());
    }

    private Object getConstant(IField field) {
        try {
            return field.getConstant();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public Source source() {
        Optional<IFile> file = this.types.stream().filter(type -> type.getResource() != null).map(IJavaElement::getResource).filter(resource -> resource instanceof IFile).map(IFile.class::cast).findFirst();
        if (file.isPresent()) {
            return new ResourceSource(file.orElseThrow());
        }
        return new ResourceSource(this.types.iterator().next());
    }

    public boolean isInterface() {
        try {
            return this.types.iterator().next().isInterface();
        }
        catch (JavaModelException e) {
            this.logError("Unable to tell if resolved class is an interface", (Exception)((Object)e));
            return false;
        }
    }

    private JdtResolvedClass() {
    }

    public int hashCode() {
        return this.jdtName.hashCode();
    }

    public boolean equals(Object obj) {
        return Equality.referenceEquals((Object)this, (Object)obj).orElse(other -> new EqualsBuilder().append((Object)this.jdtName, (Object)other.jdtName).build());
    }

    public static class Builder {
        private JdtResolvedClass resolvedClass = new JdtResolvedClass();

        public JdtResolvedClass build() {
            Objects.requireNonNull(this.resolvedClass.resolver);
            if (this.resolvedClass.types.isEmpty()) {
                throw new IllegalStateException("Resolved class must have at least one linked type");
            }
            Set javaNames = this.resolvedClass.types.stream().map(type -> type.getFullyQualifiedName('.')).collect(Collectors.toSet());
            if (javaNames.size() > 1) {
                throw new IllegalStateException("Conflicting java names");
            }
            this.resolvedClass.javaName = new ClassName((String)javaNames.iterator().next());
            Set jdtNames = this.resolvedClass.types.stream().map(IType::getFullyQualifiedName).collect(Collectors.toSet());
            if (jdtNames.size() > 1) {
                throw new IllegalStateException("Conflicting JDT names");
            }
            this.resolvedClass.jdtName = (String)jdtNames.iterator().next();
            return this.resolvedClass;
        }

        public Builder resolver(JdtClassResolver resolver) {
            this.resolvedClass.resolver = resolver;
            return this;
        }

        public Builder types(Collection<IType> types) {
            this.resolvedClass.types.clear();
            this.resolvedClass.types.addAll(types);
            return this;
        }
    }
}

