/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class BuilderState
implements Serializable {
    private Serializable sourceModelVisitorState;
    private Serializable validationModelVisitorState;

    public void serialize(IFile stateFile) throws IOException, CoreException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bytes);
        oos.writeObject(this.sourceModelVisitorState);
        oos.writeObject(this.validationModelVisitorState);
        oos.close();
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(bytes.toByteArray());
        if (stateFile.exists()) {
            stateFile.setContents((InputStream)byteInputStream, 1, null);
        } else {
            stateFile.create((InputStream)byteInputStream, false, null);
        }
    }

    public static BuilderState deserialize(IFile stateFile) throws Exception {
        BuilderState state = new BuilderState();
        ObjectInputStream ois = new ObjectInputStream(stateFile.getContents());
        state.sourceModelVisitorState = (Serializable)ois.readObject();
        state.validationModelVisitorState = (Serializable)ois.readObject();
        ois.close();
        return state;
    }

    public void setSourceModelVisitorState(Serializable serializableState) {
        this.sourceModelVisitorState = serializableState;
    }

    public Serializable getSourceModelVisitorState() {
        return this.sourceModelVisitorState;
    }

    public void setValidationModelVisitorState(Serializable serializableState) {
        this.validationModelVisitorState = serializableState;
    }

    public Serializable getValidationModelVisitorState() {
        return this.validationModelVisitorState;
    }
}

