/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import poussecafe.source.Source;

public class ResourceSource
extends Source
implements Serializable {
    private transient IType type;
    private transient ICompilationUnit compilationUnit;
    private transient IFile file;
    private String relativePath;
    private String typeName;

    public IType sourceType() {
        return this.type;
    }

    private void connectedOrThrow() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Connect resource to a project");
        }
    }

    public boolean isConnected() {
        return this.type != null;
    }

    public boolean hasFile() {
        this.connectedOrThrow();
        return this.file != null;
    }

    public void configure(ASTParser parser) {
        parser.setSource(this.resourceCompilationUnit());
    }

    public ICompilationUnit resourceCompilationUnit() {
        this.connectedOrThrow();
        return this.compilationUnit;
    }

    public IFile file() {
        this.connectedOrThrow();
        return this.file;
    }

    public ResourceSource(IFile file) {
        super(ResourceSource.sourceId(file));
        IJavaProject project = JavaCore.create((IProject)file.getProject());
        this.relativePath = file.getProjectRelativePath().toString();
        this.connect(project);
    }

    public static String sourceId(IFile file) {
        return file.getProjectRelativePath().toString();
    }

    public ResourceSource(IType type) {
        super(type.getFullyQualifiedName());
        this.typeName = type.getFullyQualifiedName();
        this.connect(type.getJavaProject());
    }

    public void connect(Object project) {
        Objects.requireNonNull(project);
        IJavaProject javaProject = (IJavaProject)project;
        if (this.relativePath != null) {
            Path path = new Path(this.relativePath);
            this.file = javaProject.getProject().getFile((IPath)path);
            if (this.file == null || !this.file.isAccessible()) {
                this.file = null;
            } else {
                this.compilationUnit = (ICompilationUnit)JavaCore.create((IResource)this.file, (IJavaProject)javaProject);
                if (this.compilationUnit != null) {
                    this.type = this.compilationUnit.findPrimaryType();
                    if (this.type != null) {
                        this.typeName = this.type.getFullyQualifiedName();
                    }
                }
            }
        }
        if (this.type == null) {
            this.relativePath = null;
            try {
                this.type = javaProject.findType(this.typeName);
            }
            catch (Exception exception) {}
        }
    }

    ResourceSource() {
    }
}

