/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import poussecafe.eclipse.plugin.core.PousseCafeProject;
import poussecafe.eclipse.plugin.editors.EmilEditor;
import poussecafe.source.emil.parser.Tree;
import poussecafe.source.emil.parser.TreeAnalyzer;
import poussecafe.source.emil.parser.TreeParser;
import poussecafe.source.generation.CoreCodeGenerator;
import poussecafe.source.generation.internal.InternalStorageAdaptersCodeGenerator;
import poussecafe.source.model.Aggregate;
import poussecafe.source.model.SourceModel;
import poussecafe.spring.jpa.storage.source.JpaStorageAdaptersCodeGenerator;
import poussecafe.spring.mongo.storage.source.MongoStorageAdaptersCodeGenerator;

public class GenerateCodeHandler
extends AbstractHandler {
    private static final String DIALOG_TITLE = "Pousse-Caf\u00e9 code generator";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IEditorPart activeEditor = window.getActivePage().getActiveEditor();
        if (activeEditor instanceof EmilEditor) {
            EmilEditor activeEmilEditor = (EmilEditor)activeEditor;
            if (!activeEmilEditor.isDirty()) {
                Tree tree = TreeParser.parseString((String)activeEmilEditor.getContent());
                if (tree.isValid()) {
                    PousseCafeProject project = activeEmilEditor.getPousseCafeProject();
                    if (project.model().isEmpty()) {
                        MessageDialog.openWarning((Shell)window.getShell(), (String)DIALOG_TITLE, (String)"Build the project first or wait for current build to finish.");
                    } else {
                        this.tryGenerateCode(window, tree, project);
                    }
                } else {
                    MessageDialog.openError((Shell)window.getShell(), (String)DIALOG_TITLE, (String)"Cannot generated code, invalid EMIL.");
                }
            } else {
                MessageDialog.openInformation((Shell)window.getShell(), (String)DIALOG_TITLE, (String)"Save editor's content first.");
            }
        }
        return null;
    }

    private void tryGenerateCode(IWorkbenchWindow window, Tree tree, PousseCafeProject project) {
        try {
            boolean proceed = project.hasProblems() ? MessageDialog.openQuestion((Shell)window.getShell(), (String)DIALOG_TITLE, (String)"It is recommanded to fix problems before generating code, do you want to continue?") : true;
            if (proceed) {
                this.generateCode(window, project, tree);
                MessageDialog.openInformation((Shell)window.getShell(), (String)DIALOG_TITLE, (String)"Code successfully generated.");
            }
        }
        catch (Exception e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error("Error while generating code", (Throwable)e);
            MessageDialog.openError((Shell)window.getShell(), (String)DIALOG_TITLE, (String)"Failed to generate code.");
        }
    }

    private void generateCode(IWorkbenchWindow window, PousseCafeProject project, Tree tree) {
        try {
            window.getShell().setEnabled(false);
            SourceModel newModel = this.buildNewModel(project, tree);
            this.updateCode(project, newModel);
            this.refreshResources(project);
        }
        finally {
            window.getShell().setEnabled(true);
        }
    }

    private SourceModel buildNewModel(PousseCafeProject project, Tree tree) {
        TreeAnalyzer analyzer = new TreeAnalyzer.Builder().tree(tree).basePackage(project.getBasePackage()).build();
        analyzer.analyze();
        return analyzer.model();
    }

    private void updateCode(PousseCafeProject project, SourceModel newModel) {
        InternalStorageAdaptersCodeGenerator.Builder internalGeneratorBuilder;
        CoreCodeGenerator.Builder generatorBuilder = new CoreCodeGenerator.Builder().sourceDirectory(project.getSourceFolder()).classResolver(project.buildClassResolver());
        generatorBuilder.currentModel(project.model().orElseThrow());
        generatorBuilder.preferencesContext(InstanceScope.INSTANCE);
        CoreCodeGenerator generator = generatorBuilder.build();
        generator.generate(newModel);
        if (project.usesInternalStorage()) {
            internalGeneratorBuilder = new InternalStorageAdaptersCodeGenerator.Builder().sourceDirectory(project.getSourceFolder());
            internalGeneratorBuilder.preferencesContext(InstanceScope.INSTANCE);
            for (Aggregate aggregate : newModel.aggregates()) {
                internalGeneratorBuilder.build().generate(aggregate);
            }
        }
        if (project.usesSpringMongoStorage()) {
            internalGeneratorBuilder = new MongoStorageAdaptersCodeGenerator.Builder().sourceDirectory(project.getSourceFolder());
            internalGeneratorBuilder.preferencesContext(InstanceScope.INSTANCE);
            for (Aggregate aggregate : newModel.aggregates()) {
                internalGeneratorBuilder.build().generate(aggregate);
            }
        }
        if (project.usesSpringJpaStorage()) {
            internalGeneratorBuilder = new JpaStorageAdaptersCodeGenerator.Builder().sourceDirectory(project.getSourceFolder());
            internalGeneratorBuilder.preferencesContext(InstanceScope.INSTANCE);
            for (Aggregate aggregate : newModel.aggregates()) {
                internalGeneratorBuilder.build().generate(aggregate);
            }
        }
    }

    private void refreshResources(PousseCafeProject project) {
        try {
            project.getJavaProject().getProject().refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

