/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.handlers;

import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import poussecafe.eclipse.plugin.handlers.ProjectSelectionIterator;

public class AddRemovePousseCafeNatureHandler
extends AbstractHandler {
    @Inject
    private ILog logger;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            ProjectSelectionIterator it = ProjectSelectionIterator.iterate((IStructuredSelection)selection);
            while (it.hasNext()) {
                IProject project = it.next();
                try {
                    this.toggleNature(project);
                }
                catch (CoreException e) {
                    this.logger.error("Failed to toggle nature");
                    throw new ExecutionException("Failed to toggle nature", (Throwable)e);
                }
            }
        }
        return null;
    }

    private void toggleNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if ("poussecafe.eclipse.plugin.pousseCafeNature".equals(natures[i])) {
                String[] newNatures = new String[natures.length - 1];
                System.arraycopy(natures, 0, newNatures, 0, i);
                System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "poussecafe.eclipse.plugin.pousseCafeNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }
}

