/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.handlers;

import java.net.URL;
import java.time.LocalDateTime;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.handlers.HandlerUtil;
import poussecafe.doc.PousseCafeDocGenerationConfiguration;
import poussecafe.doc.PousseCafeDocGenerator;
import poussecafe.eclipse.plugin.builder.PousseCafeNature;
import poussecafe.eclipse.plugin.core.PousseCafeCore;
import poussecafe.eclipse.plugin.core.PousseCafeProject;
import poussecafe.eclipse.plugin.handlers.ProjectSelectionIterator;
import poussecafe.source.model.SourceModel;

public class GenerateDocHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            ProjectSelectionIterator it = ProjectSelectionIterator.iterate((IStructuredSelection)selection);
            while (it.hasNext()) {
                IProject project = it.next();
                if (!PousseCafeNature.isPousseCafeProject(project)) continue;
                PousseCafeProject pousseCafeProject = PousseCafeCore.getProject(JavaCore.create((IProject)project));
                this.generateDocAndOpen(pousseCafeProject);
            }
        }
        return null;
    }

    private boolean generateDocAndOpen(PousseCafeProject pousseCafeProject) {
        Optional<SourceModel> sourceModel = pousseCafeProject.model();
        if (sourceModel.isPresent()) {
            try {
                this.generateDoc(pousseCafeProject, sourceModel);
                this.openDocInBrowser(pousseCafeProject);
                return true;
            }
            catch (CoreException e) {
                Platform.getLog(((Object)((Object)this)).getClass()).error("Error while generating doc", (Throwable)e);
            }
        }
        return false;
    }

    private void generateDoc(PousseCafeProject pousseCafeProject, Optional<SourceModel> sourceModel) throws CoreException {
        PousseCafeDocGenerator generator = PousseCafeDocGenerator.builder().configuration(PousseCafeDocGenerationConfiguration.builder().domainName(pousseCafeProject.getDomain()).outputDirectory(pousseCafeProject.getDocumentationFolder().toString()).version(LocalDateTime.now().toString()).pdfFileName("project.pdf").build()).model(sourceModel.orElseThrow()).build();
        generator.generate();
    }

    private void openDocInBrowser(PousseCafeProject pousseCafeProject) {
        try {
            URL url = new URL("file://" + pousseCafeProject.getDocumentationFolder().resolve("index.html").toString());
            if (pousseCafeProject.openDocInExternalBrownser()) {
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
            } else {
                String browserId = String.valueOf(pousseCafeProject.getJavaProject().getProject().getName()) + "PousseCafeDocBrowserId";
                IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(browserId);
                browser.openURL(url);
            }
        }
        catch (Exception e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error("Error while generating doc", (Throwable)e);
        }
    }
}

