/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.hyperlink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import poussecafe.eclipse.plugin.actions.OpenJavaEditorAction;
import poussecafe.eclipse.plugin.builder.ResourceSource;
import poussecafe.eclipse.plugin.core.JavaNameResolver;
import poussecafe.eclipse.plugin.core.PousseCafeCore;
import poussecafe.eclipse.plugin.core.PousseCafeProject;
import poussecafe.eclipse.plugin.editors.ActionHyperlink;
import poussecafe.source.analysis.ClassName;
import poussecafe.source.analysis.CompilationUnitResolver;
import poussecafe.source.model.MessageListener;

public class MessageListenerHyperlinkDetector
extends AbstractHyperlinkDetector {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor editor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (!(editor.getEditorInput() instanceof IFileEditorInput)) {
            return this.noResult();
        }
        try {
            if (!this.isEligibleContent()) {
                return this.noResult();
            }
            ArrayList<IHyperlink> links = new ArrayList<IHyperlink>();
            links.addAll(this.detectLinksOfListener(region));
            links.addAll(this.detectLinksOfMessage(region));
            return this.arrayOrNull(links);
        }
        catch (Exception e) {
            this.logger.error("Unable to detect hyperlinks", (Throwable)e);
            return this.noResult();
        }
    }

    private boolean isEligibleContent() {
        return PousseCafeProject.isPousseCafeProjectCompilationUnit(this.editedFile());
    }

    private IFile editedFile() {
        ITextEditor editor = (ITextEditor)this.getAdapter(ITextEditor.class);
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
        return input.getFile();
    }

    private IHyperlink[] noResult() {
        return this.arrayOrNull(Collections.emptyList());
    }

    private IHyperlink[] arrayOrNull(List<IHyperlink> links) {
        if (links.isEmpty()) {
            return null;
        }
        IHyperlink[] array = new IHyperlink[links.size()];
        return links.toArray(array);
    }

    private List<IHyperlink> detectLinksOfListener(IRegion region) throws JavaModelException {
        IMethod methodForRegion = this.findMethodForRegion(region);
        if (methodForRegion == null) {
            return Collections.emptyList();
        }
        return this.methodLinks(region, methodForRegion);
    }

    private IMethod findMethodForRegion(IRegion region) throws JavaModelException {
        IType primaryType = this.compilationUnitPrimaryType();
        return this.findMethodForRegion(primaryType, region);
    }

    private IType compilationUnitPrimaryType() {
        IFile file = this.editedFile();
        ICompilationUnit compilationUnit = (ICompilationUnit)JavaCore.create((IFile)file);
        return compilationUnit.findPrimaryType();
    }

    private IMethod findMethodForRegion(IType type, IRegion region) throws JavaModelException {
        IType[] iTypeArray = type.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType innerType = iTypeArray[n2];
            ISourceRange typeRange = innerType.getSourceRange();
            if (SourceRange.isAvailable((ISourceRange)typeRange) && this.rangeContainsRegion(typeRange, region)) {
                return this.findMethodForRegion(innerType, region);
            }
            ++n2;
        }
        iTypeArray = type.getMethods();
        n = iTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            IType method = iTypeArray[n2];
            ISourceRange methodRange = method.getSourceRange();
            if (SourceRange.isAvailable((ISourceRange)methodRange) && this.rangeContainsRegion(methodRange, region)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private boolean rangeContainsRegion(ISourceRange methodRange, IRegion region) {
        return methodRange.getOffset() <= region.getOffset() && this.endOf(methodRange) >= this.endOf(region);
    }

    private int endOf(IRegion region) {
        return region.getOffset() + region.getLength();
    }

    private int endOf(ISourceRange range) {
        return range.getOffset() + range.getLength();
    }

    private List<IHyperlink> methodLinks(IRegion target, IMethod method) throws JavaModelException {
        IMemberValuePair producedEventMemberValuePair;
        IAnnotation producedEvent;
        IJavaProject javaProject = method.getJavaProject();
        PousseCafeProject pousseCafeProject = PousseCafeCore.getProject(javaProject);
        if (pousseCafeProject.model().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IHyperlink> links = new ArrayList<IHyperlink>();
        if (this.isMessageListener(method) && this.targetIsConsumedMessageName(target, method)) {
            String messageName = this.consumedMessageName(method);
            links.addAll(this.producers(pousseCafeProject, messageName, this.region(method)));
        }
        if ((producedEvent = this.findProducesEventAnnotationForTarget(target, method)) != null && (producedEventMemberValuePair = producedEvent.getMemberValuePairs()[0]).getValueKind() == 11) {
            String messageTypeName = (String)producedEventMemberValuePair.getValue();
            String messageName = new ClassName(messageTypeName).simple();
            links.addAll(this.consumers(pousseCafeProject, messageName, this.region(method)));
        }
        return links;
    }

    private boolean targetIsConsumedMessageName(IRegion region, IMethod methodForRegion) throws JavaModelException {
        return methodForRegion.getParameters().length == 1 && this.rangeContainsRegion(methodForRegion.getParameters()[0].getSourceRange(), region);
    }

    private boolean isMessageListener(IMethod method) throws JavaModelException {
        IType declaringType = method.getDeclaringType();
        IAnnotation[] iAnnotationArray = method.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String annotationTypeName = annotation.getElementName();
            String resolvedAnnotationTypeName = JavaNameResolver.resolve(declaringType, annotationTypeName);
            if (CompilationUnitResolver.MESSAGE_LISTENER_ANNOTATION_CLASS.equals(resolvedAnnotationTypeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String consumedMessageName(IMethod method) {
        return JavaNameResolver.simpleName(method.getParameterTypes()[0]);
    }

    private List<IHyperlink> producers(PousseCafeProject pousseCafeProject, String messageName, IRegion linkRegion) throws JavaModelException {
        ArrayList<IHyperlink> links = new ArrayList<IHyperlink>();
        List<MessageListener> listeners = pousseCafeProject.model().orElseThrow().messageListeners().stream().filter(listener -> listener.producedEvents().stream().anyMatch(producedEvent -> producedEvent.message().name().equals(messageName))).collect(Collectors.toList());
        links.addAll(this.buildLinksToListeners(linkRegion, pousseCafeProject.getJavaProject(), listeners, "Producer"));
        return links;
    }

    private List<IHyperlink> buildLinksToListeners(IRegion region, IJavaProject project, List<MessageListener> listeners, String listenerType) throws JavaModelException {
        ArrayList<IHyperlink> links = new ArrayList<IHyperlink>(listeners.size());
        ITextEditor editor = (ITextEditor)this.getAdapter(ITextEditor.class);
        for (MessageListener listener : listeners) {
            ResourceSource source = (ResourceSource)listener.source();
            source.connect(project);
            ICompilationUnit compilationUnit = (ICompilationUnit)JavaCore.create((IFile)source.file());
            IType containerType = compilationUnit.findPrimaryType();
            IMethod listenerMethod = this.locateListenerMethod(containerType, listener);
            if (listenerMethod == null) continue;
            OpenJavaEditorAction action = new OpenJavaEditorAction.Builder().member((IMember)listenerMethod).site((IWorkbenchSite)editor.getEditorSite()).build();
            links.add(new ActionHyperlink.Builder().action(action).name(String.valueOf(listenerType) + " " + listener.id()).region(region).build());
        }
        return links;
    }

    private IMethod locateListenerMethod(IType type, MessageListener listener) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (this.isMessageListener(method, listener)) {
                return method;
            }
            ++n2;
        }
        iMethodArray = type.getTypes();
        n = iMethodArray.length;
        n2 = 0;
        while (n2 < n) {
            IMethod innerType = iMethodArray[n2];
            IMethod method = this.locateListenerMethod((IType)innerType, listener);
            if (method != null) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private IRegion region(IMethod methodForRegion) throws JavaModelException {
        ISourceRange sourceRange = methodForRegion.getParameters().length == 1 ? methodForRegion.getParameters()[0].getSourceRange() : methodForRegion.getNameRange();
        return this.region(sourceRange);
    }

    private IRegion region(ISourceRange sourceRange) {
        return new Region(sourceRange.getOffset(), sourceRange.getLength());
    }

    private boolean isMessageListener(IMethod method, MessageListener listener) throws JavaModelException {
        return this.isMessageListener(method) && method.getParameterTypes().length == 1 && listener.consumedMessage().name().equals(this.consumedMessageName(method));
    }

    private IAnnotation findProducesEventAnnotationForTarget(IRegion target, IMethod method) throws JavaModelException {
        IType declaringType = method.getDeclaringType();
        IAnnotation[] iAnnotationArray = method.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String annotationTypeName = annotation.getElementName();
            String resolvedAnnotationTypeName = JavaNameResolver.resolve(declaringType, annotationTypeName);
            if (CompilationUnitResolver.PRODUCES_EVENT_ANNOTATION_CLASS.equals(resolvedAnnotationTypeName) && this.rangeContainsRegion(annotation.getSourceRange(), target)) {
                return annotation;
            }
            ++n2;
        }
        return null;
    }

    private List<IHyperlink> consumers(PousseCafeProject pousseCafeProject, String messageName, IRegion linkRegion) throws JavaModelException {
        List<MessageListener> consumers = pousseCafeProject.model().orElseThrow().messageListeners().stream().filter(listener -> listener.consumedMessage().name().equals(messageName)).collect(Collectors.toList());
        return this.buildLinksToListeners(linkRegion, pousseCafeProject.getJavaProject(), consumers, "Consumer");
    }

    private List<IHyperlink> detectLinksOfMessage(IRegion region) throws JavaModelException, IllegalArgumentException {
        IType primaryType = this.compilationUnitPrimaryType();
        IJavaProject javaProject = primaryType.getJavaProject();
        PousseCafeProject pousseCafeProject = PousseCafeCore.getProject(javaProject);
        if (pousseCafeProject.model().isEmpty()) {
            return Collections.emptyList();
        }
        if (this.isMessageDefinition(primaryType)) {
            ISourceRange nameSourceRange = primaryType.getNameRange();
            String messageName = primaryType.getElementName();
            ArrayList<IHyperlink> links = new ArrayList<IHyperlink>();
            links.addAll(this.producers(pousseCafeProject, messageName, this.region(nameSourceRange)));
            links.addAll(this.consumers(pousseCafeProject, messageName, this.region(nameSourceRange)));
            return links;
        }
        return Collections.emptyList();
    }

    private boolean isMessageDefinition(IType type) throws JavaModelException, IllegalArgumentException {
        if (CompilationUnitResolver.MESSAGE_CLASS.equals(type.getFullyQualifiedName('.'))) {
            return true;
        }
        IJavaProject javaProject = type.getJavaProject();
        String[] stringArray = type.getSuperInterfaceTypeSignatures();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String superinterfaceSignature = stringArray[n2];
            String superinterfaceName = JavaNameResolver.resolveSignature(type, superinterfaceSignature);
            IType superinterface = javaProject.findType(superinterfaceName);
            if (superinterface != null && this.isMessageDefinition(superinterface)) {
                return true;
            }
            ++n2;
        }
        String superclassSignature = type.getSuperclassTypeSignature();
        if (superclassSignature != null) {
            String superclassName = JavaNameResolver.resolveSignature(type, superclassSignature);
            if (superclassName.equals("java.lang.Object")) {
                return false;
            }
            IType superclass = javaProject.findType(superclassName);
            if (superclass != null && this.isMessageDefinition(superclass)) {
                return true;
            }
        }
        return false;
    }
}

