/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class PousseCafeProjectPropertyPage
extends PropertyPage {
    private static final String POUSSE_CAFE_PROPERTY_QUALIFIER = "poussecafe";
    private static final String BASE_PACKAGE_TITLE = "Base package:";
    public static final QualifiedName BASE_PACKAGE_PROPERTY_NAME = new QualifiedName("poussecafe", "basePackage");
    public static final String DEFAULT_BASE_PACKAGE = "default.base.package";
    private static final String SOURCE_FOLDER_TITLE = "Source folder:";
    public static final QualifiedName SOURCE_FOLDER_PROPERTY_NAME = new QualifiedName("poussecafe", "sourceFolder");
    public static final String DEFAULT_SOURCE_FOLDER = "src/";
    public static final QualifiedName DOMAIN_PROPERTY_NAME = new QualifiedName("poussecafe", "domain");
    public static final String DEFAULT_DOMAIN = "My Domain";
    private static final int TEXT_FIELD_WIDTH = 50;
    public static final QualifiedName USES_INTERNAL_STORAGE_PROPERTY_NAME = new QualifiedName("poussecafe", "usesInternalStorage");
    public static final String DEFAULT_USES_INTERNAL_STORAGE = "true";
    public static final QualifiedName USES_SPRING_MONGO_STORAGE_PROPERTY_NAME = new QualifiedName("poussecafe", "usesSpringMongoStorage");
    public static final String DEFAULT_USES_SPRING_MONGO_STORAGE = "false";
    public static final QualifiedName USES_SPRING_JPA_STORAGE_PROPERTY_NAME = new QualifiedName("poussecafe", "usesSpringJpaStorage");
    public static final String DEFAULT_USES_SPRING_JPA_STORAGE = "false";
    public static final QualifiedName OPEN_IN_EXTERNAL_BROWSER_PROPERTY_NAME = new QualifiedName("poussecafe", "openInExternalBrowser");
    public static final String DEFAULT_OPEN_IN_EXTERNAL_BROWSER = "false";
    private Composite pageRoot;
    private Text basePackageText;
    private Text sourceFolderText;
    private Text domainText;
    private Button openInExternalBrowser;
    private Button usesInternalStorage;
    private Button usesSpringMongoStorage;
    private Button usesSpringJpaStorage;

    protected Control createContents(Composite parent) {
        this.pageRoot = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.pageRoot.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        this.pageRoot.setLayoutData((Object)data);
        this.addGeneralSection();
        this.addSeparator();
        this.addDocumentationSection();
        this.addSeparator();
        this.addStorageSection();
        return this.pageRoot;
    }

    private void addGeneralSection() {
        Composite fieldsComposite = this.createTwoColumnsComposite();
        this.basePackageText = this.addField(fieldsComposite, BASE_PACKAGE_TITLE, BASE_PACKAGE_PROPERTY_NAME, DEFAULT_BASE_PACKAGE);
        this.sourceFolderText = this.addField(fieldsComposite, SOURCE_FOLDER_TITLE, SOURCE_FOLDER_PROPERTY_NAME, DEFAULT_SOURCE_FOLDER);
    }

    private Composite createTwoColumnsComposite() {
        Composite composite = new Composite(this.pageRoot, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Text addField(Composite parent, String title, QualifiedName propertyName, String defaultValue) {
        Label label = new Label(parent, 0);
        label.setText(title);
        Text field = new Text(parent, 2052);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        field.setLayoutData((Object)gd);
        try {
            String value = this.getResource().getPersistentProperty(propertyName);
            field.setText(value != null ? value : defaultValue);
        }
        catch (CoreException coreException) {
            field.setText(defaultValue);
        }
        return field;
    }

    private IResource getResource() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IResource)element;
        }
        return (IResource)this.getElement().getAdapter(IProject.class);
    }

    private void addSeparator() {
        Label separator = new Label(this.pageRoot, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addDocumentationSection() {
        Composite fieldsComposite = this.createTwoColumnsComposite();
        this.domainText = this.addField(fieldsComposite, "Domain name:", DOMAIN_PROPERTY_NAME, DEFAULT_DOMAIN);
        this.openInExternalBrowser = this.addCheckbox(fieldsComposite, "Open in external browser", OPEN_IN_EXTERNAL_BROWSER_PROPERTY_NAME, Boolean.parseBoolean("false"));
    }

    private void addStorageSection() {
        Composite storageComposite = this.createTwoColumnsComposite();
        this.usesInternalStorage = this.addCheckbox(storageComposite, "Uses internal storage", USES_INTERNAL_STORAGE_PROPERTY_NAME, Boolean.parseBoolean(DEFAULT_USES_INTERNAL_STORAGE));
        this.usesSpringMongoStorage = this.addCheckbox(storageComposite, "Uses Spring Mongo storage", USES_SPRING_MONGO_STORAGE_PROPERTY_NAME, Boolean.parseBoolean("false"));
        this.usesSpringJpaStorage = this.addCheckbox(storageComposite, "Uses Spring JPA storage", USES_SPRING_JPA_STORAGE_PROPERTY_NAME, Boolean.parseBoolean("false"));
    }

    private Button addCheckbox(Composite parent, String title, QualifiedName propertyName, boolean defaultValue) {
        Label label = new Label(parent, 0);
        label.setText(title);
        Button field = new Button(parent, 32);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        field.setLayoutData((Object)gd);
        try {
            String value = this.getResource().getPersistentProperty(propertyName);
            field.setSelection(value != null ? Boolean.parseBoolean(value) : defaultValue);
        }
        catch (CoreException coreException) {
            field.setSelection(defaultValue);
        }
        return field;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.basePackageText.setText(DEFAULT_BASE_PACKAGE);
        this.sourceFolderText.setText(DEFAULT_SOURCE_FOLDER);
        this.domainText.setText(DEFAULT_DOMAIN);
        this.openInExternalBrowser.setSelection(Boolean.parseBoolean("false"));
        this.usesInternalStorage.setSelection(Boolean.parseBoolean(DEFAULT_USES_INTERNAL_STORAGE));
        this.usesSpringMongoStorage.setSelection(Boolean.parseBoolean("false"));
        this.usesSpringJpaStorage.setSelection(Boolean.parseBoolean("false"));
    }

    public boolean performOk() {
        try {
            this.getResource().setPersistentProperty(BASE_PACKAGE_PROPERTY_NAME, this.basePackageText.getText());
            this.getResource().setPersistentProperty(SOURCE_FOLDER_PROPERTY_NAME, this.sourceFolderText.getText());
            this.getResource().setPersistentProperty(DOMAIN_PROPERTY_NAME, this.domainText.getText());
            this.getResource().setPersistentProperty(OPEN_IN_EXTERNAL_BROWSER_PROPERTY_NAME, Boolean.toString(this.openInExternalBrowser.getSelection()));
            this.getResource().setPersistentProperty(USES_INTERNAL_STORAGE_PROPERTY_NAME, Boolean.toString(this.usesInternalStorage.getSelection()));
            this.getResource().setPersistentProperty(USES_SPRING_MONGO_STORAGE_PROPERTY_NAME, Boolean.toString(this.usesSpringMongoStorage.getSelection()));
            this.getResource().setPersistentProperty(USES_SPRING_JPA_STORAGE_PROPERTY_NAME, Boolean.toString(this.usesSpringJpaStorage.getSelection()));
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }
}

