/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;
import poussecafe.eclipse.plugin.core.PousseCafeProject;
import poussecafe.source.emil.EmilExporter;
import poussecafe.source.model.SourceModel;

public class OpenEmilEditorAction
extends Action {
    private PousseCafeProject project;
    private String processName;
    private IWorkbenchWindow workbenchWindow;

    public void run() {
        Optional model = this.project.model();
        if (model.isPresent()) {
            EmilExporter exporter = new EmilExporter.Builder().model((SourceModel)model.get()).processName(Optional.of(this.processName)).build();
            String emil = exporter.toEmil();
            try {
                String emilFileName = this.emilFileName(this.processName);
                IFile emilFile = this.project.createTempFile(emilFileName);
                ByteArrayInputStream buffer = new ByteArrayInputStream(emil.getBytes());
                if (emilFile.exists()) {
                    emilFile.setContents((InputStream)buffer, 1, null);
                } else {
                    emilFile.create((InputStream)buffer, false, null);
                }
                IEditorRegistry editorRegistry = this.workbenchWindow.getWorkbench().getEditorRegistry();
                IEditorDescriptor editorDescriptor = editorRegistry.getDefaultEditor(emilFileName);
                this.workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(emilFile), editorDescriptor.getId());
            }
            catch (CoreException e) {
                Platform.getLog(this.getClass()).error("Unable to write EMIL file", (Throwable)e);
            }
        }
    }

    private String emilFileName(String processName) {
        return processName + ".emil";
    }

    private OpenEmilEditorAction() {
    }
}

