/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import poussecafe.eclipse.plugin.builder.JdtClassResolver;
import poussecafe.eclipse.plugin.builder.JdtResolvedClass;
import poussecafe.source.analysis.ClassName;
import poussecafe.source.analysis.ResolvedClass;
import poussecafe.source.validation.ClassPathExplorer;

public class JdtClassPathExplorer
implements ClassPathExplorer {
    private JdtClassResolver classResolver;

    public Set<ResolvedClass> getSubTypesOf(ClassName superTypeName) {
        Optional<JdtResolvedClass> resolvedClass = this.classResolver.loadClass(superTypeName).map(JdtResolvedClass.class::cast);
        if (resolvedClass.isPresent()) {
            HashMap<String, List> subTypes = new HashMap<String, List>();
            for (IType resolvedType : resolvedClass.get().types()) {
                ITypeHierarchy hierarchy = this.classResolver.typeHierarchies().newTypeHierarchy(resolvedType);
                IType[] iTypeArray = hierarchy.getSubtypes(resolvedType);
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType resolvedTypeSubType = iTypeArray[n2];
                    List resolvedTypeSubTypes = subTypes.computeIfAbsent(resolvedTypeSubType.getFullyQualifiedName(), name -> new ArrayList());
                    resolvedTypeSubTypes.add(resolvedTypeSubType);
                    ++n2;
                }
            }
            return subTypes.values().stream().map(types -> this.classResolver.resolve((Collection)types)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public JdtClassPathExplorer(JdtClassResolver classResolver) {
        Objects.requireNonNull(classResolver);
        this.classResolver = classResolver;
    }
}

