/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import poussecafe.eclipse.plugin.builder.JdtResolvedClass;
import poussecafe.eclipse.plugin.builder.TypeHierarchies;
import poussecafe.eclipse.plugin.core.JavaNameResolver;
import poussecafe.eclipse.plugin.core.JavaSearchEngine;
import poussecafe.source.analysis.ClassName;
import poussecafe.source.analysis.ClassResolver;

public class JdtClassResolver
extends ClassResolver {
    private Map<ClassName, List<IType>> searchResults = new HashMap();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IJavaProject project;
    private TypeHierarchies typeHierarchies = new TypeHierarchies();
    private JavaSearchEngine searchEngine;
    private Map<String, Boolean> instanceOfRelations = new HashMap();

    protected JdtResolvedClass loadClass(String name) throws ClassNotFoundException {
        List types = this.loadType(name);
        if (types.isEmpty()) {
            throw new ClassNotFoundException(name);
        }
        return this.resolve((Collection)types);
    }

    List<IType> loadType(String name) throws ClassNotFoundException {
        try {
            IType type = this.project.findType(name);
            if (type == null) {
                return this.searchType(new ClassName(name));
            }
            return Arrays.asList(type);
        }
        catch (JavaModelException e) {
            throw new ClassNotFoundException("Error while searching for type " + name, e);
        }
    }

    private List<IType> searchType(ClassName typeName) {
        return this.searchResults.computeIfAbsent(typeName, arg_0 -> this.doSearchType(arg_0));
    }

    private List<IType> doSearchType(ClassName typeName) {
        this.logger.debug("Searching for type {}", (Object)typeName);
        return this.searchEngine.searchType(typeName);
    }

    public JdtResolvedClass resolve(Collection<IType> types) {
        return new JdtResolvedClass.Builder().resolver(this).types(types).build();
    }

    public JdtClassResolver(IJavaProject project) {
        Objects.requireNonNull(project);
        this.project = project;
        this.searchEngine = new JavaSearchEngine();
    }

    public TypeHierarchies typeHierarchies() {
        return this.typeHierarchies;
    }

    public boolean instanceOf(JdtResolvedClass subject, JdtResolvedClass supertype) {
        String relation = this.relation(subject, supertype);
        Boolean value = (Boolean)this.instanceOfRelations.get(relation);
        if (value != null) {
            return value;
        }
        value = this.computeInstanceOf(subject, supertype);
        this.instanceOfRelations.put(relation, value);
        return value;
    }

    private String relation(JdtResolvedClass subject, JdtResolvedClass supertype) {
        return subject.name().toString() + "+" + supertype.name().toString();
    }

    private Boolean computeInstanceOf(JdtResolvedClass subject, JdtResolvedClass supertype) {
        if (subject.isInterface() && !supertype.isInterface()) {
            return false;
        }
        if (supertype.name().equals((Object)subject.name())) {
            return true;
        }
        try {
            for (IType type : subject.types()) {
                if (!this.computeInstanceOf(type, supertype)) continue;
                return true;
            }
            return false;
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    private boolean computeInstanceOf(IType type, JdtResolvedClass supertype) throws JavaModelException {
        String superclassSignature;
        if (supertype.isInterface()) {
            String[] stringArray = type.getSuperInterfaceTypeSignatures();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String superinterfaceSignature = stringArray[n2];
                String superinterfaceName = JavaNameResolver.resolveSignature((IType)type, (String)superinterfaceSignature);
                Optional<JdtResolvedClass> superinterface = this.loadClass(new ClassName(superinterfaceName)).map(JdtResolvedClass.class::cast);
                if (superinterface.isPresent() && this.instanceOf(superinterface.get(), supertype)) {
                    return true;
                }
                ++n2;
            }
        }
        if ((superclassSignature = type.getSuperclassTypeSignature()) != null && !superclassSignature.equals("java.lang.Object")) {
            String superclassName = JavaNameResolver.resolveSignature((IType)type, (String)superclassSignature);
            Optional<JdtResolvedClass> superclass = this.loadClass(new ClassName(superclassName)).map(JdtResolvedClass.class::cast);
            if (superclass.isPresent() && this.instanceOf(superclass.get(), supertype)) {
                return true;
            }
        }
        return false;
    }
}

