/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import poussecafe.eclipse.plugin.builder.BuilderState;
import poussecafe.eclipse.plugin.builder.JdtClassPathExplorer;
import poussecafe.eclipse.plugin.builder.JdtClassResolver;
import poussecafe.eclipse.plugin.builder.ResourceSource;
import poussecafe.eclipse.plugin.builder.Resources;
import poussecafe.eclipse.plugin.core.PousseCafeCore;
import poussecafe.eclipse.plugin.core.PousseCafeProject;
import poussecafe.source.Source;
import poussecafe.source.SourceScanner;
import poussecafe.source.analysis.ClassResolver;
import poussecafe.source.analysis.ResolvedCompilationUnitVisitor;
import poussecafe.source.analysis.SourceModelBuilderVisitor;
import poussecafe.source.analysis.TypeResolvingCompilationUnitVisitor;
import poussecafe.source.validation.ClassPathExplorer;
import poussecafe.source.validation.SourceLine;
import poussecafe.source.validation.ValidationMessage;
import poussecafe.source.validation.ValidationMessageType;
import poussecafe.source.validation.ValidationModelBuilderVisitor;
import poussecafe.source.validation.ValidationResult;
import poussecafe.source.validation.Validator;
import poussecafe.source.validation.types.InteralStorageTypesValidator;
import poussecafe.source.validation.types.StorageTypesValidator;
import poussecafe.spring.jpa.storage.source.JpaTypesValidator;
import poussecafe.spring.mongo.storage.source.MongoTypesValidator;

public class PousseCafeBuilder
extends IncrementalProjectBuilder {
    public static final String MARKER_TYPE = "poussecafe.eclipse.plugin.pousseCafeProblem";
    private ILog platformLogger = Platform.getLog(this.getClass());
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private BuilderState latestBuilderState;
    public static final String TRY_INCREMENTAL_FIRST_ARG = "tryIncrementalFirst";
    private JdtClassResolver classResolver;
    private IJavaProject javaProject;
    private ValidationModelBuilderVisitor validationVisitor;
    private SourceModelBuilderVisitor sourceModelVisitor;
    private SourceScanner scanner;
    private Validator validator;
    private PousseCafeProject pousseCafeProject;
    public static final String BUILDER_ID = "poussecafe.eclipse.plugin.pousseCafeBuilder";

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.deleteProjectPousseCafeMarkers();
        this.clearBuilderState();
    }

    private void clearBuilderState() {
        this.scanner = null;
        this.latestBuilderState = null;
        PousseCafeProject project = this.pousseCafeProject();
        try {
            IFile stateFile = project.builderStateFile();
            if (stateFile.exists()) {
                stateFile.delete(true, null);
            }
        }
        catch (CoreException e) {
            this.platformLogger.error("Unable to delete state file", (Throwable)e);
        }
    }

    private void deleteProjectPousseCafeMarkers() {
        try {
            this.getProject().deleteMarkers(MARKER_TYPE, true, 2);
        }
        catch (CoreException e) {
            this.platformLogger.error("Unable to delete markers", (Throwable)e);
        }
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Pousse-Caf\u00e9 build: " + this.getProject().getName(), 4);
        this.initBuilder();
        if (this.isIncrementalBuild(kind, args)) {
            monitor.subTask("Pousse-Caf\u00e9 build: incremental...");
            this.incrementalBuild();
        } else {
            monitor.subTask("Pousse-Caf\u00e9 build: full...");
            this.fullBuild(monitor);
        }
        this.persistBuilderState();
        monitor.worked(1);
        monitor.subTask("Pousse-Caf\u00e9 build: validating...");
        this.validateProject();
        monitor.worked(2);
        monitor.subTask("Pousse-Caf\u00e9 build: refreshing model...");
        this.refreshPousseCafeProject();
        monitor.worked(3);
        monitor.subTask("Pousse-Caf\u00e9 build: refreshing markers...");
        this.refreshMarkers();
        monitor.worked(4);
        return new IProject[0];
    }

    private void initBuilder() {
        if (this.scanner == null) {
            this.classResolver = new JdtClassResolver(this.javaProject());
            this.validationVisitor = new ValidationModelBuilderVisitor();
            this.sourceModelVisitor = new SourceModelBuilderVisitor();
            this.scanner = new SourceScanner(new TypeResolvingCompilationUnitVisitor.Builder().withClassResolver((ClassResolver)this.classResolver).withVisitor((ResolvedCompilationUnitVisitor)this.sourceModelVisitor).withVisitor((ResolvedCompilationUnitVisitor)this.validationVisitor).build());
            this.tryLoadPersistedState();
        }
    }

    private void tryLoadPersistedState() {
        try {
            long start = System.currentTimeMillis();
            this.logger.debug("Trying to load persited state");
            PousseCafeProject project = this.pousseCafeProject();
            IFile stateFile = project.builderStateFile();
            if (stateFile.exists()) {
                this.latestBuilderState = BuilderState.deserialize((IFile)stateFile);
                this.sourceModelVisitor.loadSerializedState(this.latestBuilderState.getSourceModelVisitorState());
                this.validationVisitor.loadSerializedState(this.latestBuilderState.getValidationModelVisitorState());
            }
            long end = System.currentTimeMillis();
            this.logger.debug("Successfully loaded persisted state in {} ms", (Object)(end - start));
        }
        catch (Exception e) {
            this.platformLogger.info("Could not deserialize latest build state", (Throwable)e);
            this.latestBuilderState = null;
        }
    }

    private boolean isIncrementalBuild(int kind, Map<String, String> args) {
        boolean tryIncrementalFirst = this.tryIncrementalFirst(args);
        return this.latestBuilderState != null && (kind == 6 && tryIncrementalFirst || kind == 10 || kind == 9);
    }

    private boolean tryIncrementalFirst(Map<String, String> args) {
        return args != null && args.get(TRY_INCREMENTAL_FIRST_ARG) != null && Boolean.parseBoolean(args.get(TRY_INCREMENTAL_FIRST_ARG));
    }

    private void incrementalBuild() {
        this.logger.info("Starting incremental build...");
        long start = System.currentTimeMillis();
        IResourceDelta delta = this.getDelta(this.getProject());
        List updatedResources = this.relevantDeltas(delta);
        for (IResourceDelta source : updatedResources) {
            IFile file = (IFile)source.getResource();
            String sourceId = ResourceSource.sourceId((IFile)file);
            if (source.getKind() == 1 || source.getKind() == 4) {
                ResourceSource resource = new ResourceSource(file);
                resource.connect((Object)this.javaProject());
                if (!resource.isConnected()) continue;
                this.logger.debug("Including {}", (Object)sourceId);
                this.includeFile(resource);
                continue;
            }
            if (source.getKind() == 2) {
                this.logger.debug("Forgetting {}", (Object)sourceId);
                this.scanner.forget(sourceId);
                continue;
            }
            this.logger.warn("Unsupported delta kind {} with resource {}", (Object)source.getKind(), (Object)sourceId);
        }
        long end = System.currentTimeMillis();
        this.logger.info("Scanned delta in {} ms", (Object)(end - start));
    }

    private void fullBuild(IProgressMonitor monitor) {
        this.logger.info("Starting full build...");
        long start = System.currentTimeMillis();
        try {
            PousseCafeProject project = this.pousseCafeProject();
            IPackageFragment[] iPackageFragmentArray = this.javaProject().getPackageFragments();
            int n = iPackageFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment fragmentRoot = iPackageFragmentArray[n2];
                String fragmentRootName = fragmentRoot.getElementName();
                if (fragmentRootName.startsWith(project.getBasePackage())) {
                    this.include(monitor, fragmentRoot);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            this.platformLogger.error("Unable to build project", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        this.logger.info("Scanned project in {} ms", (Object)(end - start));
    }

    private void include(IProgressMonitor monitor, IPackageFragment fragmentRoot) throws JavaModelException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IJavaElement[] iJavaElementArray = fragmentRoot.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (child instanceof ICompilationUnit) {
                IFile file = (IFile)child.getResource();
                monitor.subTask("Pousse-Caf\u00e9 build: scanning " + file.getName());
                this.includeFile(new ResourceSource(file));
            } else if (child instanceof IClassFile) {
                monitor.subTask("Pousse-Caf\u00e9 build: scanning " + child.getElementName());
                this.includeFile(new ResourceSource((IClassFile)child));
            } else {
                this.logger.debug("Unsupported child type: " + child.getClass().getCanonicalName());
            }
            ++n2;
        }
    }

    private List<IResourceDelta> relevantDeltas(IResourceDelta delta) {
        ArrayList<IResourceDelta> updatedResources = new ArrayList<IResourceDelta>();
        this.addRelevantDeltas(updatedResources, delta);
        return updatedResources;
    }

    private void addRelevantDeltas(List<IResourceDelta> resources, IResourceDelta delta) {
        if (delta != null) {
            IResource resource = delta.getResource();
            if (Resources.isJavaSourceFile((IResource)resource)) {
                resources.add(delta);
            } else {
                IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta child = iResourceDeltaArray[n2];
                    this.addRelevantDeltas(resources, child);
                    ++n2;
                }
            }
        }
    }

    private IJavaProject javaProject() {
        if (this.javaProject == null) {
            this.javaProject = JavaCore.create((IProject)this.getProject());
        }
        return this.javaProject;
    }

    private void includeFile(ResourceSource source) {
        try {
            if (source.hasSource()) {
                this.scanner.includeSource((Source)source);
                this.logger.debug("Included {}", (Object)source.id());
            }
        }
        catch (Exception e) {
            this.platformLogger.error("Error while scanning " + source.id(), (Throwable)e);
        }
    }

    private void persistBuilderState() {
        this.latestBuilderState = new BuilderState();
        this.latestBuilderState.setSourceModelVisitorState(this.sourceModelVisitor.getSerializableState());
        this.latestBuilderState.setValidationModelVisitorState(this.validationVisitor.getSerializableState());
        try {
            IFile stateFile = this.pousseCafeProject().builderStateFile();
            this.latestBuilderState.serialize(stateFile);
        }
        catch (Exception e) {
            this.platformLogger.info("Could not serialize latest build state", (Throwable)e);
            this.latestBuilderState = null;
        }
    }

    private void validateProject() {
        Validator.Builder builder = new Validator.Builder().model(this.validationVisitor.buildModel()).classResolver((ClassResolver)this.classResolver).classPathExplorer((ClassPathExplorer)new JdtClassPathExplorer(this.classResolver));
        if (this.pousseCafeProject().usesInternalStorage()) {
            builder.storageTypesValidator((StorageTypesValidator)new InteralStorageTypesValidator());
        }
        if (this.pousseCafeProject().usesSpringJpaStorage()) {
            builder.storageTypesValidator((StorageTypesValidator)new JpaTypesValidator());
        }
        if (this.pousseCafeProject().usesSpringMongoStorage()) {
            builder.storageTypesValidator((StorageTypesValidator)new MongoTypesValidator());
        }
        this.validator = builder.build();
        this.validator.validate();
    }

    private void refreshPousseCafeProject() {
        this.pousseCafeProject().refresh(this.sourceModelVisitor.buildModel());
    }

    private PousseCafeProject pousseCafeProject() {
        if (this.pousseCafeProject == null) {
            this.pousseCafeProject = PousseCafeCore.getProject((IJavaProject)this.javaProject());
        }
        return this.pousseCafeProject;
    }

    private void refreshMarkers() {
        this.deleteProjectPousseCafeMarkers();
        ValidationResult result = this.validator.result();
        for (ValidationMessage message : result.messages()) {
            SourceLine location = message.location();
            ResourceSource resourceSource = (ResourceSource)location.source();
            resourceSource.connect((Object)this.javaProject());
            IFile file = resourceSource.file();
            if (file != null) {
                this.addMarker(file, message.message(), location.line(), this.severity(message.type()));
                continue;
            }
            this.platformLogger.error("Unknown file " + location.source().id());
        }
    }

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException e) {
            this.platformLogger.error("Unable to add marker", (Throwable)e);
        }
    }

    private int severity(ValidationMessageType type) {
        if (type == ValidationMessageType.ERROR) {
            return 2;
        }
        if (type == ValidationMessageType.WARNING) {
            return 1;
        }
        return 0;
    }
}

