/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import poussecafe.eclipse.plugin.editors.EmilEditor;
import poussecafe.eclipse.plugin.editors.EmilStringParser;
import poussecafe.eclipse.plugin.editors.EmilToken;
import poussecafe.eclipse.plugin.editors.Style;
import poussecafe.source.emil.parser.EmilParser;

public class EmilTokenScanner
implements ITokenScanner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int rangeOffset;
    private int rangeLength;
    private List<EmilToken> tokens = new ArrayList();
    private EmilEditor editor;
    private EmilParser.ProcessContext tree;
    private Style style;
    private Iterator<EmilToken> tokenIterator;
    private EmilToken nextToken;

    public void setRange(IDocument document, int offset, int length) {
        this.logger.debug("Scanning range {}..{}", (Object)offset, (Object)(offset + length - 1));
        this.rangeOffset = offset;
        this.rangeLength = length;
        this.editor.clearMarkers();
        EmilStringParser parser = new EmilStringParser(document.get());
        if (parser.errors().isEmpty()) {
            this.tokens.clear();
            this.tree = parser.tree();
            this.computeTokens();
        } else {
            for (EmilStringParser.Error error : parser.errors()) {
                this.editor.addMarker(error.message(), error.line(), 2, error.position());
            }
        }
        this.tokenIterator = this.tokens.iterator();
    }

    private void computeTokens() {
        this.computeHeaderTokens(this.tree.header());
        this.computeConsumptionsTokens(this.tree.consumptions());
        this.padIfNecessary(this.rangeOffset + this.rangeLength);
    }

    private void computeHeaderTokens(EmilParser.HeaderContext header) {
        this.computeToken(header.getStart(), this.keywordTextAttribute());
    }

    private void computeToken(org.antlr.v4.runtime.Token singleRuleToken, TextAttribute textAttribute) {
        this.computeToken(singleRuleToken, singleRuleToken, textAttribute);
    }

    private void computeToken(org.antlr.v4.runtime.Token start, org.antlr.v4.runtime.Token stop, TextAttribute textAttribute) {
        int length;
        int offset = this.offset(start);
        if (this.isRegionInRange(offset, length = this.length(start, stop))) {
            this.padIfNecessary(offset);
            this.tokens.add(new EmilToken(offset, length, (Object)textAttribute));
        }
    }

    private int offset(org.antlr.v4.runtime.Token start) {
        return start.getStartIndex();
    }

    private int length(org.antlr.v4.runtime.Token start, org.antlr.v4.runtime.Token stop) {
        int startIndex = start.getStartIndex();
        int endIndex = stop.getStopIndex();
        return endIndex - startIndex + 1;
    }

    private boolean isRegionInRange(int offset, int length) {
        return offset + length - 1 >= this.rangeOffset && offset < this.rangeOffset + this.rangeLength;
    }

    private void padIfNecessary(int nextTokenOffset) {
        if (!this.tokens.isEmpty() && ((EmilToken)this.tokens.get(this.tokens.size() - 1)).endInclusive() < nextTokenOffset - 1) {
            int offset = ((EmilToken)this.tokens.get(this.tokens.size() - 1)).endInclusive() + 1;
            int end = nextTokenOffset - 1;
            int length = end - offset + 1;
            this.tokens.add(new EmilToken(offset, length, (Object)this.defaultTextAttribute()));
        }
    }

    private TextAttribute defaultTextAttribute() {
        Color foregroundColor = this.style.colorManager().getColor(Style.DEFAULT_FOREGROUND_COLOR);
        Color backgroundColor = this.style.colorManager().getColor(Style.DEFAULT_BACKGROUND_COLOR);
        return new TextAttribute(foregroundColor, backgroundColor, 0, this.style.defaultTextFont());
    }

    private TextAttribute keywordTextAttribute() {
        Color foregroundColor = this.style.colorManager().getColor(Style.KEYWORD_COLOR);
        Color backgroundColor = this.style.colorManager().getColor(Style.DEFAULT_BACKGROUND_COLOR);
        return new TextAttribute(foregroundColor, backgroundColor, 0, this.style.defaultBoldTextFont());
    }

    private void computeConsumptionsTokens(EmilParser.ConsumptionsContext consumptions) {
        for (EmilParser.ConsumptionContext consumption : consumptions.consumption()) {
            if (consumption.eventConsumption() != null) {
                this.computeEventConsumptionTokens(consumption.eventConsumption());
            }
            if (consumption.commandConsumption() == null) continue;
            this.computeCommandConsumptionTokens(consumption.commandConsumption());
        }
    }

    private void computeEventConsumptionTokens(EmilParser.EventConsumptionContext eventConsumption) {
        if (eventConsumption.external() != null) {
            this.computeExternalToken(eventConsumption.external());
        }
        this.computeToken(eventConsumption.event().NAME().getSymbol(), this.eventNameTextAttribute());
        this.computeMessageConsumptionsTokens(eventConsumption.messageConsumptions());
    }

    private void computeExternalToken(EmilParser.ExternalContext external) {
        this.computeToken(external.getStart(), external.getStop(), this.externalTextAttribute());
    }

    private TextAttribute externalTextAttribute() {
        Color foregroundColor = this.style.colorManager().getColor(Style.EXTERNAL_COLOR);
        Color backgroundColor = this.style.colorManager().getColor(Style.DEFAULT_BACKGROUND_COLOR);
        return new TextAttribute(foregroundColor, backgroundColor, 0, this.style.defaultTextFont());
    }

    private TextAttribute eventNameTextAttribute() {
        Color foregroundColor = this.style.colorManager().getColor(Style.EVENT_NAME_COLOR);
        Color backgroundColor = this.style.colorManager().getColor(Style.DEFAULT_BACKGROUND_COLOR);
        return new TextAttribute(foregroundColor, backgroundColor, 0, this.style.defaultTextFont());
    }

    private void computeMessageConsumptionsTokens(EmilParser.MessageConsumptionsContext messageConsumptions) {
        if (messageConsumptions.singleMessageConsumption() != null) {
            this.computeSingleMessageConsumptionTokens(messageConsumptions.singleMessageConsumption());
        } else if (messageConsumptions.multipleMessageConsumptions() != null) {
            List singleConsumptions = messageConsumptions.multipleMessageConsumptions().multipleMessageConsumptionsItem().stream().map(EmilParser.MultipleMessageConsumptionsItemContext::singleMessageConsumption).collect(Collectors.toList());
            for (EmilParser.SingleMessageConsumptionContext singleConsumption : singleConsumptions) {
                this.computeSingleMessageConsumptionTokens(singleConsumption);
            }
        }
    }

    private void computeSingleMessageConsumptionTokens(EmilParser.SingleMessageConsumptionContext singleMessageConsumption) {
        if (singleMessageConsumption.factoryConsumption() != null) {
            this.computeFactoryConsumptionTokens(singleMessageConsumption.factoryConsumption());
        } else if (singleMessageConsumption.repositoryConsumption() != null) {
            this.computeRepositoryConsumptionTokens(singleMessageConsumption.repositoryConsumption());
        } else if (singleMessageConsumption.aggregateRootConsumption() != null) {
            this.computeAggregateRootConsumptionTokens(singleMessageConsumption.aggregateRootConsumption());
        } else if (singleMessageConsumption.processConsumption() != null) {
            this.computeProcessConsumptionTokens(singleMessageConsumption.processConsumption());
        } else if (singleMessageConsumption.emptyConsumption() != null) {
            this.computeEmptyConsumptionTokens(singleMessageConsumption.emptyConsumption());
        }
    }

    private void computeFactoryConsumptionTokens(EmilParser.FactoryConsumptionContext factoryConsumption) {
        this.computeFactoryListenerTokens(factoryConsumption.factoryListener());
        if (factoryConsumption.aggregateRoot() != null && factoryConsumption.eventProductions() != null) {
            this.computeNameTokens(factoryConsumption.aggregateRoot().simpleRootName, factoryConsumption.aggregateRoot().qualifiedRootName);
            this.computeHookToken((TerminalNode)factoryConsumption.getChild(3));
            this.computeEventProductionsTokens(factoryConsumption.eventProductions());
        }
    }

    private void computeHookToken(TerminalNode hookName) {
        this.computeToken(hookName.getSymbol(), this.hookNameTextAttribute());
    }

    private TextAttribute hookNameTextAttribute() {
        Color foregroundColor = this.style.colorManager().getColor(Style.DEFAULT_FOREGROUND_COLOR);
        Color backgroundColor = this.style.colorManager().getColor(Style.DEFAULT_BACKGROUND_COLOR);
        return new TextAttribute(foregroundColor, backgroundColor, 0, this.style.defaultItalicTextFont());
    }

    private void computeFactoryListenerTokens(EmilParser.FactoryListenerContext factoryListener) {
        TerminalNode fLiteral = (TerminalNode)factoryListener.getChild(0);
        this.computeToken(fLiteral.getSymbol(), this.keywordTextAttribute());
        this.computeNameTokens(factoryListener.simpleFactoryName, factoryListener.qualifiedFactoryName);
        this.computeListenerNameToken(factoryListener.listenerName);
        if (factoryListener.optional != null) {
            this.computeToken(factoryListener.optional, this.multiplicitySymbolTextAttribute());
        }
        if (factoryListener.serveral != null) {
            this.computeToken(factoryListener.serveral, this.multiplicitySymbolTextAttribute());
        }
    }

    private void computeNameTokens(org.antlr.v4.runtime.Token simpleName, EmilParser.QualifiedNameContext qualifiedName) {
        if (simpleName != null) {
            this.computeSimpleNameToken(simpleName);
        } else if (qualifiedName != null) {
            this.computeQualifiedNameToken(qualifiedName);
        }
    }

    private void computeSimpleNameToken(org.antlr.v4.runtime.Token simpleFactoryName) {
        this.computeToken(simpleFactoryName, this.nameTextAttribute());
    }

    private TextAttribute nameTextAttribute() {
        Color foregroundColor = this.style.colorManager().getColor(Style.NAME_COLOR);
        Color backgroundColor = this.style.colorManager().getColor(Style.DEFAULT_BACKGROUND_COLOR);
        return new TextAttribute(foregroundColor, backgroundColor, 0, this.style.defaultTextFont());
    }

    private void computeQualifiedNameToken(EmilParser.QualifiedNameContext qualifiedFactoryName) {
        this.computeToken(qualifiedFactoryName.qualifier, this.nameTextAttribute());
    }

    private void computeListenerNameToken(org.antlr.v4.runtime.Token listenerName) {
        this.computeToken(listenerName, this.listenerNameTextAttribute());
    }

    private TextAttribute listenerNameTextAttribute() {
        Color foregroundColor = this.style.colorManager().getColor(Style.LISTENER_NAME_COLOR);
        Color backgroundColor = this.style.colorManager().getColor(Style.DEFAULT_BACKGROUND_COLOR);
        return new TextAttribute(foregroundColor, backgroundColor, 0, this.style.defaultTextFont());
    }

    private TextAttribute multiplicitySymbolTextAttribute() {
        Color foregroundColor = this.style.colorManager().getColor(Style.MULTIPLICITY_SYMBOL_COLOR);
        Color backgroundColor = this.style.colorManager().getColor(Style.DEFAULT_BACKGROUND_COLOR);
        return new TextAttribute(foregroundColor, backgroundColor, 0, this.style.defaultBoldTextFont());
    }

    private void computeEventProductionsTokens(EmilParser.EventProductionsContext eventProductions) {
        for (EmilParser.EventProductionContext production : eventProductions.eventProduction()) {
            this.computeEventProductionTokens(production);
        }
    }

    private void computeEventProductionTokens(EmilParser.EventProductionContext production) {
        this.computeToken(production.event().NAME().getSymbol(), this.eventNameTextAttribute());
        if (production.optional != null) {
            this.computeToken(production.optional, this.multiplicitySymbolTextAttribute());
        }
        this.computeMessageConsumptionsTokens(production.messageConsumptions());
    }

    private void computeRepositoryConsumptionTokens(EmilParser.RepositoryConsumptionContext repositoryConsumption) {
        TerminalNode reLiteral = (TerminalNode)repositoryConsumption.getChild(0);
        this.computeToken(reLiteral.getSymbol(), this.keywordTextAttribute());
        this.computeNameTokens(repositoryConsumption.simpleRepositoryName, repositoryConsumption.qualifiedRepositoryName);
        this.computeListenerNameToken(repositoryConsumption.listenerName);
        if (repositoryConsumption.aggregateRoot() != null && repositoryConsumption.eventProductions() != null) {
            this.computeNameTokens(repositoryConsumption.aggregateRoot().simpleRootName, repositoryConsumption.aggregateRoot().qualifiedRootName);
            this.computeHookToken(this.onDeleteHookToken(repositoryConsumption));
            this.computeEventProductionsTokens(repositoryConsumption.eventProductions());
        }
    }

    private TerminalNode onDeleteHookToken(EmilParser.RepositoryConsumptionContext repositoryConsumption) {
        int i = 0;
        while (i < repositoryConsumption.getChildCount()) {
            TerminalNode terminalNode;
            ParseTree child = repositoryConsumption.getChild(i);
            if (child instanceof TerminalNode && (terminalNode = (TerminalNode)child).getText().equals("onDelete")) {
                return terminalNode;
            }
            ++i;
        }
        throw new IllegalArgumentException("onDelete hook not found");
    }

    private void computeAggregateRootConsumptionTokens(EmilParser.AggregateRootConsumptionContext aggregateRootConsumption) {
        TerminalNode ruLiteral = (TerminalNode)aggregateRootConsumption.getChild(0);
        this.computeToken(ruLiteral.getSymbol(), this.keywordTextAttribute());
        this.computeNameTokens(aggregateRootConsumption.aggregateRoot().simpleRootName, aggregateRootConsumption.aggregateRoot().qualifiedRootName);
        this.computeListenerNameToken(aggregateRootConsumption.listenerName);
        if (aggregateRootConsumption.eventProductions() != null) {
            this.computeEventProductionsTokens(aggregateRootConsumption.eventProductions());
        }
    }

    private void computeProcessConsumptionTokens(EmilParser.ProcessConsumptionContext processConsumption) {
        TerminalNode pLiteral = (TerminalNode)processConsumption.getChild(0);
        this.computeToken(pLiteral.getSymbol(), this.keywordTextAttribute());
        this.computeToken(processConsumption.processName, this.processNameTextAttribute());
    }

    private TextAttribute processNameTextAttribute() {
        Color foregroundColor = this.style.colorManager().getColor(Style.PROCESS_NAME_COLOR);
        Color backgroundColor = this.style.colorManager().getColor(Style.DEFAULT_BACKGROUND_COLOR);
        return new TextAttribute(foregroundColor, backgroundColor, 0, this.style.defaultTextFont());
    }

    private void computeEmptyConsumptionTokens(EmilParser.EmptyConsumptionContext emptyConsumption) {
        if (emptyConsumption.external() != null) {
            this.computeExternalToken(emptyConsumption.external());
        }
    }

    private void computeCommandConsumptionTokens(EmilParser.CommandConsumptionContext commandConsumption) {
        this.computeToken(commandConsumption.command().NAME().getSymbol(), this.commandNameTextAttribute());
        this.computeMessageConsumptionsTokens(commandConsumption.messageConsumptions());
    }

    private TextAttribute commandNameTextAttribute() {
        Color foregroundColor = this.style.colorManager().getColor(Style.COMMAND_NAME_COLOR);
        Color backgroundColor = this.style.colorManager().getColor(Style.DEFAULT_BACKGROUND_COLOR);
        return new TextAttribute(foregroundColor, backgroundColor, 0, this.style.defaultTextFont());
    }

    public IToken nextToken() {
        if (this.tokenIterator.hasNext()) {
            this.nextToken = (EmilToken)this.tokenIterator.next();
            this.logToken(this.nextToken);
            return this.nextToken;
        }
        this.nextToken = null;
        return Token.EOF;
    }

    private void logToken(EmilToken token) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Issuing token (o:{}, l:{}, data:{})", new Object[]{token.offset(), token.length(), this.toString(token.getData())});
        }
    }

    private String toString(Object data) {
        if (data instanceof TextAttribute) {
            TextAttribute textAttribute = (TextAttribute)data;
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(textAttribute.getForeground());
            builder.append(",");
            builder.append(textAttribute.getBackground());
            builder.append(",");
            builder.append(textAttribute.getFont());
            builder.append("]");
            return builder.toString();
        }
        return "";
    }

    public int getTokenLength() {
        if (this.nextToken == null) {
            throw new IllegalStateException("EOF");
        }
        return this.nextToken.length();
    }

    public int getTokenOffset() {
        if (this.nextToken == null) {
            throw new IllegalStateException("EOF");
        }
        return this.nextToken.offset();
    }

    public EmilTokenScanner(EmilEditor editor) {
        Objects.requireNonNull(editor);
        this.editor = editor;
        this.style = editor.style();
    }
}

