/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.handlers;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ProjectSelectionIterator
implements Iterator<IProject> {
    private Iterator<?> selectionIterator;
    private IProject nextProject;

    @Override
    public boolean hasNext() {
        return this.nextProject != null;
    }

    @Override
    public IProject next() {
        if (this.nextProject == null) {
            throw new NoSuchElementException();
        }
        IProject project = this.nextProject;
        this.moveToNext();
        return project;
    }

    public static ProjectSelectionIterator iterate(IStructuredSelection selection) {
        ProjectSelectionIterator iterator = new ProjectSelectionIterator();
        iterator.selectionIterator = selection.iterator();
        iterator.moveToNext();
        return iterator;
    }

    private void moveToNext() {
        this.nextProject = null;
        while (this.selectionIterator.hasNext() && this.nextProject == null) {
            Object element = this.selectionIterator.next();
            if (element instanceof IProject) {
                this.nextProject = (IProject)element;
                continue;
            }
            if (!(element instanceof IAdaptable)) continue;
            this.nextProject = (IProject)((IAdaptable)element).getAdapter(IProject.class);
        }
    }

    private ProjectSelectionIterator() {
    }
}

