/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.eclipse.plugin.views;

import javax.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import poussecafe.eclipse.plugin.builder.PousseCafeNature;
import poussecafe.eclipse.plugin.core.PousseCafeCore;
import poussecafe.eclipse.plugin.core.PousseCafeProject;
import poussecafe.eclipse.plugin.views.ProcessListView;
import poussecafe.source.model.ComponentWithType;
import poussecafe.source.model.SourceModel;

public class ProcessListView
extends ViewPart {
    public static final String ID = "poussecafe.eclipse.plugin.views.ProcessListView";
    @Inject
    IWorkbench workbench;
    private TableViewer viewer;
    private ILog logger = Platform.getLog(this.getClass());
    private ISelectionListener selectionListener = (part, selection) -> {
        if (selection instanceof TreeSelection && !selection.isEmpty()) {
            TreeSelection treeSelection = (TreeSelection)selection;
            Object maybeProjectSelection = treeSelection.getFirstElement();
            if (maybeProjectSelection instanceof IJavaProject) {
                IJavaProject javaProject = (IJavaProject)maybeProjectSelection;
                this.setProject(javaProject);
            } else if (maybeProjectSelection instanceof IProject) {
                IProject projectSelection = (IProject)maybeProjectSelection;
                try {
                    if (projectSelection.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject javaProject = JavaCore.create((IProject)projectSelection);
                        this.setProject(javaProject);
                    }
                }
                catch (CoreException e) {
                    this.logger.error(e.getMessage());
                }
            }
        }
    };
    private PousseCafeProject currentProject;
    private ProjectListener projectListener = new ProjectListener(this);

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.clearList();
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(this));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
        this.registerDoubleClickAction();
        this.fillActionBar();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
        super.dispose();
    }

    private void setProject(IJavaProject javaProject) {
        PousseCafeProject newProject;
        if (PousseCafeNature.isPousseCafeProject((IJavaProject)javaProject) && this.currentProject != (newProject = PousseCafeCore.getProject((IJavaProject)javaProject))) {
            this.clearList();
            if (this.currentProject != null) {
                this.currentProject.removeListener((PousseCafeProject.ChangeListener)this.projectListener);
            }
            this.currentProject = newProject;
            this.currentProject.addListener((PousseCafeProject.ChangeListener)this.projectListener);
        }
    }

    private void clearList() {
        this.viewer.setInput((Object)new String[0]);
    }

    private void refreshProcessList() {
        String[] processNames = (String[])((SourceModel)this.currentProject.model().orElseThrow()).processes().stream().map(ComponentWithType::simpleName).sorted().toArray(String[]::new);
        1 uiJob = new /* Unavailable Anonymous Inner Class!! */;
        uiJob.schedule();
    }

    private void registerDoubleClickAction() {
        2 doubleClickAction = new /* Unavailable Anonymous Inner Class!! */;
        this.viewer.addDoubleClickListener(event -> doubleClickAction.run());
    }

    private void fillActionBar() {
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        IAction refreshListAction = this.buildRefreshListAction();
        toolBar.add(refreshListAction);
    }

    private IAction buildRefreshListAction() {
        3 action = new /* Unavailable Anonymous Inner Class!! */;
        action.setText("Reload");
        action.setToolTipText("Reload process list");
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
        return action;
    }
}

